% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotly.R
\name{plotly_legend_order}
\alias{plotly_legend_order}
\title{Order plotly legend elements.}
\usage{
plotly_legend_order(plotly, numeric_order = NULL)
}
\arguments{
\item{plotly}{A plotly object.}

\item{numeric_order}{A vector specifying the numeric order of elements. Required input.}
}
\description{
Order plotly legend elements.
}
\examples{
plot_data <- ggplot2::diamonds \%>\%
   dplyr::mutate(cut = stringr::str_to_sentence(cut)) \%>\%
   dplyr::group_by(cut, clarity) \%>\%
   dplyr::summarise(average_price = mean(price)) \%>\%
   dplyr::mutate(average_price_thousands = round(average_price / 1000, 1)) \%>\%
   dplyr::ungroup()
   
plot <- ggplot_hbar_col(data = plot_data, 
                       x_var = average_price_thousands, 
                       y_var = cut, 
                       col_var = clarity, 
                       legend_ncol = 4,
                       title = "Average diamond price by cut and clarity", 
                       x_title = "Average price ($US thousands)", 
                       y_title = "Cut")

plotly::ggplotly(plot, tooltip = "text")

plotly::ggplotly(plot, tooltip = "text") \%>\% 
   plotly_legend_order(c(4, 1:3, 5:8))
}
