% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mdtangle.R
\name{mdtangle}
\alias{mdtangle}
\title{Extract code from the code blocks in a markdown file}
\usage{
mdtangle(
  fn,
  ofn = file_subs_ext(basename(fn), ".R"),
  extra_arguments = "",
  cmd = "pandoc \%3$s -s \\"\%1$s\\" -t json -o \\"\%2$s\\"",
  ...
)
}
\arguments{
\item{fn}{filename of the markdown file (should use pandoc markdown).}

\item{ofn}{name of the resulting R-script}

\item{extra_arguments}{extra arguments passed on to pandoc. Should be a length 1
character vector.}

\item{cmd}{command used to run pandoc. See details.}

\item{...}{ignored}
}
\value{
Returns the filename of the generated file.
}
\description{
Extract code from the code blocks in a markdown file
}
\details{
\code{mdtangle} calls pandoc. Pandoc will parse the markdown document and
write the parsed file to temporary file. This file is read by
\code{mdtangle} and the code is extracted from it and written to \code{ofn}.

Using the \code{cmd} argument the exact command used to run pandoc can be
modified. It is passed on to \code{\link{sprintf}} and uses positional
arguments: (1) name of the input file, (2) location of the temporary file
to which the parsed document is written, (3) the value of
\code{extra_arguments}.
}
