% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.simmr_input.R
\name{plot.simmr_input}
\alias{plot.simmr_input}
\title{Plot the \code{simmr_input} data created from \code{simmr_load}}
\usage{
\method{plot}{simmr_input}(
  x,
  tracers = c(1, 2),
  title = "Tracers plot",
  xlab = colnames(x$mixtures)[tracers[1]],
  ylab = colnames(x$mixtures)[tracers[2]],
  sigmas = 1,
  group = 1:x$n_groups,
  mix_name = "Mixtures",
  ggargs = NULL,
  colour = TRUE,
  ...
)
}
\arguments{
\item{x}{An object created via the function \code{\link{simmr_load}}}

\item{tracers}{The choice of tracers to plot. If there are more than two
tracers, it is recommended to plot every pair of tracers to determine
whether the mixtures lie in the mixing polygon defined by the sources}

\item{title}{A title for the graph}

\item{xlab}{The x-axis label. By default this is assumed to be delta-13C but
can be made richer if required. See examples below.}

\item{ylab}{The y-axis label. By default this is assumed to be delta-15N in
per mil but can be changed as with the x-axis label}

\item{sigmas}{The number of standard deviations to plot on the source
values. Defaults to 1.}

\item{group}{Which groups to plot. Can be a single group or multiple groups}

\item{mix_name}{A optional string containing the name of the mixture
objects, e.g. Geese.}

\item{ggargs}{Extra arguments to be included in the ggplot (e.g. axis limits)}

\item{colour}{If TRUE (default) creates a plot. If not, puts the plot in
black and white}

\item{...}{Not used}
}
\value{
isospace plot
}
\description{
This function creates iso-space (AKA tracer-space or delta-space) plots.
They are vital in determining whether the data are suitable for running in a
SIMM.
}
\details{
It is desirable to have the vast majority of the mixture observations to be
inside the convex hull defined by the food sources. When there are more than
two tracers (as in one of the examples below) it is recommended to plot all
the different pairs of the food sources. See the vignette for further
details of richer plots.
}
\examples{

# A simple example with 10 observations, 4 food sources and 2 tracers
data(geese_data_day1)
simmr_1 <- with(
  geese_data_day1,
  simmr_load(
    mixtures = mixtures,
    source_names = source_names,
    source_means = source_means,
    source_sds = source_sds,
    correction_means = correction_means,
    correction_sds = correction_sds,
    concentration_means = concentration_means
  )
)

# Plot
plot(simmr_1)

### A more complicated example with 30 obs, 3 tracers and 4 sources
data(simmr_data_2)
simmr_3 <- with(
  simmr_data_2,
  simmr_load(
    mixtures = mixtures,
    source_names = source_names,
    source_means = source_means,
    source_sds = source_sds,
    correction_means = correction_means,
    correction_sds = correction_sds,
    concentration_means = concentration_means
  )
)

# Plot 3 times - first default d13C vs d15N
plot(simmr_3)
# Now plot d15N vs d34S
plot(simmr_3, tracers = c(2, 3))
# and finally d13C vs d34S
plot(simmr_3, tracers = c(1, 3))
# See vignette('simmr') for fancier x-axis labels

# An example with multiple groups - the Geese data from Inger et al 2006
data(geese_data)
simmr_4 <- with(
  geese_data,
  simmr_load(
    mixtures = mixtures,
    source_names = source_names,
    source_means = source_means,
    source_sds = source_sds,
    correction_means = correction_means,
    correction_sds = correction_sds,
    concentration_means = concentration_means,
    group = groups
  )
)

# Print
simmr_4

# Plot
plot(simmr_4,
  xlab = expression(paste(delta^13, "C (\u2030)", sep = "")),
  ylab = expression(paste(delta^15, "N (\u2030)", sep = "")),
  title = "Isospace plot of Inger et al Geese data"
) #'
}
\seealso{
See \code{\link{plot.simmr_output}} for plotting the output of a
simmr run. See \code{\link{simmr_mcmc}} for running a simmr object once the
iso-space is deemed acceptable.
}
\author{
Andrew Parnell <andrew.parnell@mu.ie>
}
