% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajectory.R
\name{seize}
\alias{release}
\alias{release_selected}
\alias{seize}
\alias{seize_selected}
\title{Add a seize/release activity}
\usage{
seize(.trj, resource, amount = 1, continue = NULL, post.seize = NULL,
  reject = NULL)

seize_selected(.trj, amount = 1, id = 0, continue = NULL,
  post.seize = NULL, reject = NULL)

release(.trj, resource, amount = 1)

release_selected(.trj, amount = 1, id = 0)
}
\arguments{
\item{.trj}{the trajectory object.}

\item{resource}{the name of the resource.}

\item{amount}{the amount to seize/release, accepts either a numeric or a callable object
(a function) which must return a numeric.}

\item{continue}{a boolean (if \code{post.seize} OR \code{reject} is defined) or a pair of booleans
(if \code{post.seize} AND \code{reject} are defined) to indicate whether these subtrajectories
should continue to the next activity in the main trajectory.}

\item{post.seize}{an optional trajectory object which will be followed after a successful seize.}

\item{reject}{an optional trajectory object which will be followed if the arrival is rejected.}

\item{id}{selection identifier for nested usage.}
}
\value{
Returns the trajectory object.
}
\description{
Activities for seizing/releasing a resource, by name or a previously selected one.
}
\seealso{
\code{\link{select}}, \code{\link{set_capacity}}, \code{\link{set_queue_size}},
\code{\link{set_capacity_selected}}, \code{\link{set_queue_size_selected}}.
}

