% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixef_sim.r
\name{sim_fixef_single}
\alias{sim_fixef_single}
\title{Simulates design matrix for single level model.}
\usage{
sim_fixef_single(fixed, fixed_vars, n, cov_param, cor_vars = NULL,
  fact_vars = list(NULL), contrasts = NULL)
}
\arguments{
\item{fixed}{One sided formula for fixed effects in the simulation.}

\item{fixed_vars}{Character vector of covariates for design matrix.}

\item{n}{Number of clusters.}

\item{cov_param}{List of arguments to pass to the continuous generating 
 function. Required arguments include:
 \itemize{
   \item dist_fun: This is a quoted R distribution function.
   \item var_type: This is the level of variable to generate. Must be 
     'single'. Must be same order as fixed formula above.
 }
 Optional arguments to the distribution functions are in a nested list,
  see the examples for example code for this.
Does not include intercept, time, factors, or interactions.}

\item{cor_vars}{A vector of correlations between variables.}

\item{fact_vars}{A nested list of factor, categorical, or ordinal variable 
   specification, each list must include:
\itemize{
     \item numlevels = Number of levels for ordinal or factor variables.
     \item var_type = Must be 'single'.
 }
 Optional arguments include:
 \itemize{
     \item replace
     \item prob
     \item value.labels
 }
  See also \code{\link{sample}} for use of these optional arguments.}

\item{contrasts}{An optional list that specifies the contrasts to be used 
for factor variables (i.e. those variables with .f or .c). 
See \code{\link{contrasts}} for more detail.}
}
\description{
Input fixed variables, sample size, and number of within variables, 
returns design matrix.
}
\details{
Simulates the fixed effects for the \code{\link{sim_reg}} function when 
simulating a simple regression model.
}
