% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_pow.r
\name{sim_pow_glm}
\alias{sim_pow_glm}
\title{Master power simulation function for glm models.}
\usage{
sim_pow_glm(fixed, random = NULL, random3 = NULL, fixed_param,
  random_param = list(NULL), random_param3 = list(NULL), cov_param,
  k = NULL, n, p = NULL, data_str, cor_vars = NULL,
  fact_vars = list(NULL), unbal = list(level2 = FALSE, level3 = FALSE),
  unbal_design = list(level2 = NULL, level3 = NULL), missing = FALSE,
  missing_args = list(NULL), pow_param, alpha, pow_dist = c("z", "t"),
  pow_tail = c(1, 2), replicates, terms_vary = NULL, raw_power = TRUE,
  glm_fit_mod = NULL, lme4_fit_mod = NULL, glm_fit_family = NULL,
  lme4_fit_family = NULL, ...)
}
\arguments{
\item{fixed}{One sided formula for fixed effects in the simulation. 
To suppress intercept add -1 to formula.}

\item{random}{One sided formula for random effects in the simulation. 
Must be a subset of fixed.}

\item{random3}{One sided formula for random effects at third level in the 
simulation. Must be a subset of fixed(and likely of random).}

\item{fixed_param}{Fixed effect parameter values (i.e. beta weights). 
Must be same length as fixed.}

\item{random_param}{A list of named elements that must contain: 
\itemize{
   \item  random_var: variance of random parameters,
   \item  rand_gen: Name of simulation function for random effects.
}
       Optional elements are:
\itemize{
   \item ther: Theorectial mean and variance from rand_gen,
   \item ther_sim: Simulate mean/variance for standardization purposes,
   \item cor_vars: Correlation between random effects,
   \item ...: Additional parameters needed for rand_gen function.
 }}

\item{random_param3}{A list of named elements that must contain: 
\itemize{
    \item random_var: variance of random parameters,
    \item rand_gen: Name of simulation function for random effects.
}
      Optional elements are:
\itemize{
    \item ther: Theorectial mean and variance from rand_gen,
    \item ther_sim: Simulate mean/variance for standardization purposes,
    \item cor_vars: Correlation between random effects,
    \item ...: Additional parameters needed for rand_gen function.
}}

\item{cov_param}{List of arguments to pass to the continuous generating 
function, must be the same order as the variables specified in fixed. 
This list does not include intercept, time, factors, or 
interactions. Required arguments include:
\itemize{
  \item dist_fun: This is a quoted R distribution function.
  \item var_type: This is the level of variable to generate. Must be 
    either 'single', 'level1', 'level2', or 'level3'. 
    Must be same order as fixed formula above.
}
Optional arguments to the distribution functions are in a nested list,
 see the examples or vignettes for example code.}

\item{k}{Number of third level clusters.}

\item{n}{Cluster sample size.}

\item{p}{Within cluster sample size.}

\item{data_str}{Type of data. Must be "cross", "long", or "single".}

\item{cor_vars}{A vector of correlations between variables.}

\item{fact_vars}{A nested list of factor, categorical, or ordinal variable 
   specification, each list must include:
\itemize{
     \item numlevels = Number of levels for ordinal or factor variables.
     \item var_type = Must be 'single', 'level1', 'level2', or 'level3'.
 }
 Optional arguments include:
 \itemize{
     \item replace
     \item prob
     \item value.labels
 }
  See also \code{\link{sample}} for use of these optional arguments.}

\item{unbal}{A named TRUE/FALSE list specifying whether unbalanced simulation 
design is desired. The named elements must be: "level2" or "level3" representing
unbalanced simulation for level two and three respectively. Default is FALSE,
indicating balanced sample sizes at both levels.}

\item{unbal_design}{When unbal = TRUE, this specifies the design for unbalanced
simulation in one of two ways. It can represent the minimum and maximum 
sample size within a cluster via a named list. This will be drawn from a 
random uniform distribution with min and max specified. 
Secondly, the actual sample sizes within each cluster
can be specified. This takes the form of a vector that must have the same length 
as the level two or three sample size. These are specified as a named list in which
level two sample size is controlled via "level2" and level three sample size is 
controlled via "level3".}

\item{missing}{TRUE/FALSE flag indicating whether missing data should be 
simulated.}

\item{missing_args}{Additional missing arguments to pass to the missing_data 
function. See \code{\link{missing_data}} for examples.}

\item{pow_param}{Number of parameter to calculate power includes intercept 
where applicable.}

\item{alpha}{What should the per test alpha rate be used for the hypothesis 
testing.}

\item{pow_dist}{Which distribution should be used when testing hypothesis 
test, z or t?}

\item{pow_tail}{One-tailed or two-tailed test?}

\item{replicates}{How many replications should be done (i.e. the denominator 
in power calculation).}

\item{terms_vary}{A named list of terms that should vary as a function for 
the power simulation. The names must match arguments to the simulation 
function, see \code{\link{sim_glm}} for examples. Values specified here 
should not be included as arguments in the function call.}

\item{raw_power}{TRUE/FALSE indicating whether raw power output should be 
returned. Default is TRUE, which will create a new nested column with 
raw data by variable(s) manipulated in power analysis.}

\item{glm_fit_mod}{Valid glm syntax to be used for model fitting.}

\item{lme4_fit_mod}{Valid lme4 syntax to be used for model fitting.}

\item{glm_fit_family}{Valid family syntax to pass to the glm function.}

\item{lme4_fit_family}{Valid lme4 family specification passed to glmer.}

\item{...}{Current not used.}
}
\description{
Input simulation conditions, returns power for term.
}
\details{
This function is a wrapper that replicates the simulation functions for 
simple generalized regression and the generalized linear mixed model power 
functions. This function replicates the power call a specified number of 
times and prints outs a matrix with the results.
}
\examples{

# single level dichotomous (glm) example
fixed <- ~ 1 + act + diff
fixed_param <- c(0.1, 0.5, 0.3)
cov_param <- list(dist_fun = c('rnorm', 'rnorm'),
                  var_type = c("single", "single"),
                  opts = list(list(mean = 0, sd = 2),
                              list(mean = 0, sd = 4)))
n <- 50
pow_param <- c('(Intercept)', 'act', 'diff')
alpha <- .01
pow_dist <- "z"
pow_tail <- 2
replicates <- 2

power_out <- sim_pow_glm(fixed = fixed, fixed_param = fixed_param, 
                         cov_param = cov_param, 
                         n = n, data_str = "single", 
                         pow_param = pow_param, alpha = alpha,
                         pow_dist = pow_dist, pow_tail = pow_tail, 
                         replicates = replicates, raw_power = FALSE)

}
