% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simer.Genotype.r
\name{geno.cvt2}
\alias{geno.cvt2}
\title{Genotype code convertor 2}
\usage{
geno.cvt2(pop.geno, ncpus = 0)
}
\arguments{
\item{pop.geno}{genotype matrix of (0, 1, 2).}

\item{ncpus}{the number of threads used, if NULL, (logical core number - 1) is automatically used.}
}
\value{
genotype matrix of (0, 1).
}
\description{
Convert genotype matrix from (0, 1, 2) to (0, 1).
}
\details{
Build date: Jul 11, 2020
Last update: Jan 29, 2025
}
\examples{
\donttest{
library(bigmemory)
options(bigmemory.typecast.warning=FALSE)
pop.geno <- matrix(sample(c(0, 1, 2), 8, replace = TRUE), 2, 4)
pop.geno[]
bigmat <- geno.cvt2(pop.geno)
bigmat[]
pop.geno <- as.big.matrix(pop.geno, type = 'char')
bigmat <- geno.cvt2(pop.geno)
bigmat[]
}
}
\author{
Dong Yin
}
