% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simer.Phenotype.r
\name{phenotype}
\alias{phenotype}
\title{Phenotype simulation}
\usage{
phenotype(SP = NULL, verbose = TRUE)
}
\arguments{
\item{SP}{a list of all simulation parameters.}

\item{verbose}{whether to print detail.}
}
\value{
the function returns a list containing
\describe{
\item{$pheno$pop}{the population information containing environmental factors and other effects.}
\item{$pheno$pop.ind}{the number of individuals in the base population.}
\item{$pheno$pop.rep}{the repeated times of repeated records.}
\item{$pheno$pop.rep.bal}{whether repeated records are balanced.}
\item{$pheno$pop.env}{a list of environmental factors setting.}
\item{$pheno$phe.model}{a list of genetic model of phenotype such as "T1 = A + E".}
\item{$pheno$phe.h2A}{a list of additive heritability.}
\item{$pheno$phe.h2D}{a list of dominant heritability.}
\item{$pheno$phe.h2GxG}{a list of GxG interaction heritability.}
\item{$pheno$phe.h2GxE}{a list of GxE interaction heritability.}
\item{$pheno$phe.h2PE}{a list of permanent environmental heritability.}
\item{$pheno$phe.var}{a list of phenotype variance.}
\item{$pheno$phe.corA}{the additive genetic correlation matrix.}
\item{$pheno$phe.corD}{the dominant genetic correlation matrix.}
\item{$pheno$phe.corGxG}{the GxG genetic correlation matrix.}
\item{$pheno$phe.corPE}{the permanent environmental correlation matrix.}
\item{$pheno$phe.corE}{the residual correlation matrix.}
}
}
\description{
Generate single-trait or multiple-trait phenotype by mixed model.
}
\details{
Build date: Nov 14, 2018
Last update: Apr 28, 2022
}
\examples{
# Prepare environmental factor list
pop.env <- list(
  F1 = list( # fixed effect 1
    level = c("1", "2"),
    effect = list(tr1 = c(50, 30), tr2 = c(50, 30))
  ), 
  F2 = list( # fixed effect 2
    level = c("d1", "d2", "d3"),
    effect = list(tr1 = c(10, 20, 30), tr2 = c(10, 20, 30))
  ),
  C1 = list( # covariate 1
    level = c(70, 80, 90),
    slope = list(tr1 = 1.5, tr2 = 1.5)
  ),
  R1 = list( # random effect 1
    level = c("l1", "l2", "l3"),
    ratio = list(tr1 = 0.1, tr2 = 0.1)
  )
)

# Generate genotype simulation parameters
SP <- param.annot(qtn.num = list(tr1 = 10, tr2 = 10),
                  qtn.model = "A + D + A:D")
# Generate annotation simulation parameters
SP <- param.geno(SP = SP, pop.marker = 1e4, pop.ind = 1e2)
# Generate phenotype simulation parameters
SP <- param.pheno(
  SP = SP, 
  pop.ind = 100,
  pop.rep = 2, # 2 repeated record
  pop.rep.bal = TRUE, # balanced repeated record
  pop.env = pop.env,
  phe.var = list(tr1 = 100, tr2 = 100),
  phe.model = list(
    tr1 = "T1 = A + D + A:D + F1 + F2 + C1 + R1 + A:F1 + E",
    tr2 = "T2 = A + D + A:D + F1 + F2 + C1 + R1 + A:F1 + E"
  )
)

# Run annotation simulation
SP <- annotation(SP)
# Run genotype simulation
SP <- genotype(SP)
# Run phenotype simulation
SP <- phenotype(SP)
}
\references{
Kao C and Zeng Z (2002) <https://www.genetics.org/content/160/3/1243.long>
}
\author{
Dong Yin
}
