#' Mouse chromosome lengths
#'
#' Mouse chromosome lengths in cM from the Mouse Genome Informatics
#' (MGI) standard map.
#'
#' @docType data
#'
#' @usage data(mouseL_mgi)
#'
#' @format A numeric vector with lengths in cM for the 20 mouse chromosomes.
#'
#' @source Taken from Table 1 of Cox et al. (2009) A new standard
#'     genetic map for the laboratory mouse. Genetics 182:1335-1344.
#'     <https://doi.org/10.1534/genetics.109.105486}{doi:10.1534/genetics.109.105486>
#'
#' @keywords datasets
#'
#' @seealso mouseL_cox
#'
#' @examples
#' data(mouseL_mgi)
"mouseL_mgi"
