% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{join_metrics}
\alias{join_metrics}
\title{Join metrics}
\usage{
join_metrics(
  data,
  id_cols,
  metrics = c("coverage", "mse", "modSE"),
  true_value = NULL,
  ll_col = NULL,
  ul_col = NULL,
  estimates_col = NULL,
  se_col = NULL,
  p_col = NULL,
  alpha = 0.05
)
}
\arguments{
\item{data}{A \code{data.frame} that contains results from simulation study and the necessary columns to compute metrics.}

\item{id_cols}{Column name(s) on which to group data and calculate metrics.}

\item{metrics}{A vector of metrics to be calculated.}

\item{true_value}{The true parameter to be estimated.}

\item{ll_col}{Name of the column that contains the lower limit of the confidence intervals. (Required for calculating coverage.)}

\item{ul_col}{Name of the column that contains the upper limit of the confidence intervals. (Required for calculating coverage.)}

\item{estimates_col}{Name of the column that contains the parameter estimates. (Required for calculating bias, empSE, and mse.)}

\item{se_col}{Name of the column that contains the standard errors. (Required for calculating modSE.)}

\item{p_col}{Name of the column that contains the p-values. (Required for calculating rejection.)}

\item{alpha}{The nominal significance level specified. (Required for calculating rejection.)}
}
\value{
\code{data.frame} containing metrics and \code{id_cols}
}
\description{
Calculate and join selected evaluation metrics given a \code{data.frame} of simulation study results
Provides a fast way to add multiple metrics and their Monte Carlo standard errors.
}
\examples{
simulations_df <- data.frame(
  idx=rep(1:10, 100),
  idx2=sample(c("a", "b"), size=1000, replace=TRUE),
  p_value=runif(1000),
  est=rnorm(n=1000),
  conf.ll= rnorm(n=1000, mean=-20),
  conf.ul= rnorm(n=1000, mean=20)
)
res <- join_metrics(
  data=simulations_df,
  id_cols=c("idx", "idx2"),
  metrics=c("rejection", "coverage", "mse"),
  true_value=0,
  ll_col="conf.ll",
  ul_col="conf.ul",
  estimates_col="est",
  p_col="p_value",
)
}
