% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simLife.R
\name{woehler}
\alias{woehler}
\title{Woehler experiment}
\usage{
woehler(S, CL, param, opt, stress, cores = getOption("simLife.mc", 1L),
  cl = NULL)
}
\arguments{
\item{S}{non-overlapping object system}

\item{CL}{predefined clustered regions of objects, see \code{\link{simFracture}}}

\item{param}{parameter list for random generation of individual failure times}

\item{opt}{control parameters, see \code{\link{simTimes}}}

\item{stress}{list of stress levels}

\item{cores}{optional, number of cores for mulicore parallization with \code{cores=1L} (default) by \code{mclapply} which 
also can be set by a global option "\code{simLife.mc}"}

\item{cl}{optional, cluster environment object wich has priority of usage compared to multicore processing
in case of \code{cores>1}}
}
\value{
matrix of failure times, first colunm corresponds to the times
						   and the second to the stress level
}
\description{
Simulate a Woehler experiment
}
\details{
As done in a real life scenario the Woehler diagram measures the applied stress amplitude versus number
of cycles to failure. For each given stress level the function is intended to be an all-in-one wrapper
function for fatigue lifetime model simulations for different stress levels which returns a matrix of
failure times where each row corresponds to one stress level. The Woehler experiments can be simulated
in parallel based on using the package \code{snow} possibly together with \code{Rmpi} for an \code{MPI}
cluster object.
}
\examples{
\dontrun{

## Unless MS-Windows
# library(parallel)
# options(simLife.mc=2L)

# primary particles and secondary phase (ferrit) 
# which is already clustered and densified 
data(AL2MC_20p_k10_F2p_S)	

# simulation parameters 
opt <- list("vickers"=107,"distTol"=1.0,"Tmax"=10^11,
			"inAreafactor"=1.56, "outAreafactor"=1.43,
			"pointsConvHull"=10, "scale"=1e+06,"pl"=1L)

# lifetimes parameters
par <- list("P"=c(0.01,6,0.5,75,-15,1.5),
			"F"=c(0,0,0,105,-12,1),
			"const"=NULL)
	
nsim <- 10
stress <- as.list(seq(from=90,to=140,by=10))

cl <- NULL
## MPI/SOCKS/PSOCKS cluster object (even on Windows)
## must initialize RNG stream (rlecuyer) for reproducible results
# RNGkind("L'Ecuyer-CMRG")
# cl <- makeCluster(8)
# clusterSetRNGStream(cl)
	
# the following code may take some time
W <- woehler(S, CL=NULL, par, opt, stress=rep(stress,each=nsim),cores=1L,cl=cl)
woehlerDiagram(W, yrange=c(70,145))

## do not forget to stop cluster if used 
if(!is.null(cl)) stopCluster(cl)	
}
}
\author{
M. Baaske
}
