% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ITSModelingCode.R
\name{make_model_smoother}
\alias{make_model_smoother}
\title{Make a smoother that fits a model and then smooths residuals}
\usage{
make_model_smoother(fit_model, covariates)
}
\arguments{
\item{fit_model}{A function that takes data, fits a linear model, and returns
the fit model. This function needs an option to include (or not) lagged
covariates.}

\item{covariates}{A dataframe with all covariates needed in the model fitting
defined by fit_model.}
}
\value{
A smoother function that can be passed to the smoothing routines.
  This function is of the form listed above.
}
\description{
This helper function gives back a function that takes the resulting
simulation data from a single iteration of the simulation, and fits
'fit_model' to it, smoothes the residuals, and puts the predictions from
'fit_model' back.
}
\details{
This can be used to build smoothers that smooth using models other than the
model being used for extrapolation (e.g., a model without temperature).

Resulting functions have the following parameters: `res` (the data), `t0`
(start time), `outcomename`, `post.only` flag (for smoothing only post data
or not), and `smooth_k`, a tuning parameter for degree of smoothing.
}
\examples{
data( "newjersey")
modA = make_fit_season_model( ~ temperature )
modB = make_fit_season_model( ~ sin.m + cos.m )
newjersey = add_lagged_covariates( newjersey, "n.warrant", 
                                   covariates = c("sin.m", "cos.m", "temperature") )
smoother = make_model_smoother( fit_model = modA, covariates = newjersey )
class(smoother)

# Pass made function to process_outcome_model()
envelope = process_outcome_model( "n.warrant", newjersey, t0=-8, R = 1,
                                  summarize = TRUE, smooth=TRUE, 
                                  smoother = smoother, smooth_k = 11,
                                  fit.model = modB )

}
