% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ITSModelingCode.R
\name{extrapolate_model}
\alias{extrapolate_model}
\title{Extrapolate pre-policy data to post-policy era}
\usage{
extrapolate_model(
  M0,
  outcomename,
  dat,
  t0,
  R = 400,
  summarize = FALSE,
  smooth = FALSE,
  smoother = smooth_series,
  full_output = FALSE,
  fix_parameters = FALSE,
  ...
)
}
\arguments{
\item{M0}{The fit model}

\item{outcomename}{Outcome of interest (name of column)}

\item{dat}{Dataframe with data being analyzed.}

\item{t0}{Last pre-policy timepoint}

\item{R}{Number of replications}

\item{summarize}{Boolean, TRUE means collapse all simulated trajectories into
single aggregate. FALSE means return all paths.}

\item{smooth}{Boolean.  TRUE means fit a smoother to the trajectories and
look at distribution of smoothed trajectories.  FALSE means look at raw
data treajectories.}

\item{smoother}{Function to do smoothing, if smoothing set to TRUE.  Default
is smooth_series()}

\item{full_output}{TRUE means smoother returns residuals as well as smoothed
series.}

\item{fix_parameters}{Keep the parameters in the model M0 as fixed; do not
add parameter uncertainty.}

\item{...}{Extra arguments to be passed to smoother (e.g, bandwidth).}
}
\value{
Dataframe with columns corresponding to the simulations.  If
  summarize=TRUE, one row per month in original data.  If FALSE, all the
  details of all the runs are returned.
}
\description{
This function takes a fitted model and uses it to make the post-policy
predictions by simulating data.
}
\examples{
data("mecklenberg" )
mecklenberg = add_lagged_covariates( mecklenberg, "pbail"  )
mecklenberg.pre = dplyr::filter( mecklenberg, month <= 0 )
M0 = fit_model_default( mecklenberg.pre, "pbail" )
res = extrapolate_model( M0, "pbail", mecklenberg, 0, 1,
                         smooth=TRUE)
tail( res )
}
\seealso{
\code{\link{process_outcome_model}} for wrapper function for this
  method that is easier to use.
}
