% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_gamma_model.R
\name{sample_gamma_model}
\alias{sample_gamma_model}
\title{Sample gamma model(s) with parameters according to priors}
\usage{
sample_gamma_model(number_of_contributors, sampling_parameters, model_settings)
}
\arguments{
\item{number_of_contributors}{Integer}

\item{sampling_parameters}{List. Needs to contain:
\itemize{
\item min_mu. Numeric of length one.
\item max_mu. Numeric of length one.
\item min_cv. Numeric of length one.
\item max_cv. Numeric of length one.
\item degradation_shape1. Numeric of length one.
\item degradation_shape2. Numeric of length one.
}}

\item{model_settings}{List. See \link{gamma_model}.}
}
\value{
When \code{length(number_of_contributors)==1}, a single \link{gamma_model} of class \code{pg_model}. Otherwise, a list of these.
}
\description{
Sample gamma model(s) with parameters according to priors
}
\details{
In simulation studies involving many mixed DNA profiles, one often needs to generate various samples with different model parameters. This function samples a gamma model with parameters according to prior distributions. The mean peak height parameter \code{mu} is sampled uniformly between \code{min_mu} and \code{max_mu}. Likewise, the variability parameter \code{cv} is sampled uniformly between \code{min_cv} and \code{max_cv}. The degradation slope parameter \code{beta} is sampled according to a Beta distribution with parameters \code{degradation_shape1} and \code{degradation_shape2}.
}
\examples{
data(gf)

sampling_parameters <- list(min_mu = 50., max_mu = 5e3,
                           min_cv = 0.05, max_cv = 0.35,
                           degradation_shape1 = 10, degradation_shape2 = 1)

model_no_stutter <- sample_gamma_model(number_of_contributors = 2,
                                      sampling_parameters = sampling_parameters,
                                      model_settings = gf$gamma_settings_no_stutter)

model_no_stutter$parameters

}
