% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_contributor_genotypes.R
\name{sample_contributor_genotypes}
\alias{sample_contributor_genotypes}
\title{Sample genotypes for mixture contributors according to allele frequencies}
\usage{
sample_contributor_genotypes(
  contributors,
  freqs,
  pedigree,
  loci = names(freqs),
  return_non_contributors = FALSE
)
}
\arguments{
\item{contributors}{Character vector with unique names of contributors. Valid names are "U1", "U2", ... for unrelated contributors or the names of pedigree members for related contributors.}

\item{freqs}{Allele frequencies (see \link{read_allele_freqs})}

\item{pedigree}{(optionally) \link[pedtools:ped]{ped} object}

\item{loci}{Character vector of locus names (defaults to \code{names} attribute of \code{freqs})}

\item{return_non_contributors}{Logical. Should genotypes of non-contributing pedigree members also be returned?}
}
\value{
List of DataFrames with genotypes for each pedigree member. See \link{sample_genotype} for the DataFrame format.
}
\description{
Sample genotypes for mixture contributors according to allele frequencies
}
\details{
For each founder or unrelated person, a genotype is sampled randomly by drawing two alleles from allele frequencies. The non-founders get genotypes by allele dropping, see \link{sample_pedigree_genotypes} for details.
}
\examples{

# read allele frequencies
freqs <- read_allele_freqs(system.file("extdata","FBI_extended_Cauc.csv",
                           package = "simDNAmixtures"))

# define a pedigree of siblings S1 and S2 (and their parents)
ped_sibs <- pedtools::nuclearPed(children = c("S1", "S2"))

# sample genotypes for a mixture of S1 + U1 + S2
# where U1 is an unrelated person

sample_contributor_genotypes(contributors = c("S1","U1","S2"), freqs, ped_sibs)
}
