% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BinomTest.R
\name{wrapBinomTestS}
\alias{wrapBinomTestS}
\title{Wrap binom.test (test of Binomial/Bernoulli rate) from summary.}
\usage{
wrapBinomTestS(
  x,
  n,
  ...,
  p = NA,
  alternative = c("two.sided", "less", "greater"),
  conf.level = 0.95
)
}
\arguments{
\item{x}{numeric scalar, number of successes.}

\item{n}{numeric scalar, number of trials.}

\item{...}{extra arguments passed to binom.test}

\item{p}{number, hypothesized probability of success.}

\item{alternative}{passed to \code{\link[stats]{binom.test}}}

\item{conf.level}{passed to \code{\link[stats]{binom.test}}}
}
\value{
wrapped stat
}
\description{
Wrap binom.test (test of Binomial/Bernoulli rate) from summary.
}
\examples{

wrapBinomTestS(3, 7, p = 0.5)
wrapBinomTestS(300, 700, p = 0.5)


}
\seealso{
\code{\link{wrapBinomTest}}, \code{\link{wrapBinomTest.htest}}, \code{\link{wrapBinomTestS}}, \code{\link{wrapBinomTest.logical}}, \code{\link{wrapBinomTest.numeric}}, \code{\link{wrapBinomTest.data.frame}}
}
