% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_series.R
\name{read_copynumber}
\alias{read_copynumber}
\title{Read absolute copy number profile}
\usage{
read_copynumber(input, pattern = NULL, ignore_case = FALSE,
  seg_cols = c("Chromosome", "Start.bp", "End.bp", "modal_cn"),
  samp_col = "sample", use_all = FALSE, min_segnum = 0,
  genome_build = c("hg19", "hg38"), genome_measure = c("called", "wg"),
  clinical_data = NULL, complement = TRUE, verbose = FALSE, ...)
}
\arguments{
\item{input}{a \code{data.frame} or a file or a directory contains copy number profile.}

\item{pattern}{an optional regular expression used to select part of files if
\code{input} is a directory, more detail please see \link{list.files} function.}

\item{ignore_case}{logical. Should pattern-matching be case-insensitive?}

\item{seg_cols}{four characters used to specify chromosome, start position,
end position and copy number value in \code{input}, respectively.
Default use names from ABSOLUTE calling result.}

\item{samp_col}{a character used to specify the sample column name. If \code{input}
is a directory and cannot find \code{samp_col}, sample names will use file names
(set this parameter to \code{NULL} is recommended in this case).}

\item{use_all}{default is \code{FALSE}. If \code{True}, use all columns from raw input.}

\item{min_segnum}{minimal number of copy number segments within a sample.}

\item{genome_build}{genome build version, should be 'hg19' or 'hg38'.}

\item{genome_measure}{default is 'called', can be 'wg' or 'called'.
Set 'called' will use autosomo called segments size to compute total size for CNA burden calculation,
this option is useful for WES and target sequencing.
Set 'wg' will use autosome size from genome build, this option is useful for WGS, SNP etc..}

\item{clinical_data}{a \code{data.frame} representing clinical data
associated with each sample in copy number profile.}

\item{complement}{if \code{TRUE}, complement chromosome does not show in input data
with normal copy 2 and force \code{use_all} to \code{FALSE} (no matter what user input).}

\item{verbose}{print extra messages.}

\item{...}{other parameters pass to \code{\link[data.table:fread]{data.table::fread()}}}
}
\value{
a \link{CopyNumber} object
}
\description{
Read \strong{absolute} copy number profile for preparing CNV signature
analysis.
}
\examples{
# Load toy dataset of absolute copynumber profile
load(system.file("extdata", "toy_segTab.RData",
  package = "sigminer", mustWork = TRUE
))
cn <- read_copynumber(segTabs,
  seg_cols = c("chromosome", "start", "end", "segVal"),
  genome_build = "hg19", complement = FALSE, verbose = TRUE
)
}
\seealso{
Other read genomic variation data function series: \code{\link{read_maf}},
  \code{\link{read_variation}}
}
\author{
Shixiang Wang \href{mailto:w_shixiang@163.com}{w_shixiang@163.com}
}
\concept{read genomic variation data function series}
