% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kluster.R
\name{kluster}
\alias{kluster}
\title{Automatically cluster 1-dimensional continuous data.}
\usage{
kluster(x, bw = "SJ", fixed = FALSE)
}
\arguments{
\item{x}{Vector to be clustered. Must contain at least 1 non-missing value.}

\item{bw}{kernel bandwidth. Default "SJ" should suffice more application, however you can supply a custom numeric value. See ?stats::density for more information.}

\item{fixed}{logical; if \code{TRUE}, performs simple 1-dimensional clustering without kernel density estimation. default FALSE.}
}
\value{
An integer vector identifying the cluster corresponding to each element in \code{x}.
}
\description{
Automatically cluster 1-dimensional continuous data.
}
\examples{
# Below vector clearly has 2 groups.
# kluster will identify these groups using kernel density estimation.
kluster(c(0.1, 0.2, 1))

# kluster shines in cases where manually assigning groups via "eyeballing" is impractical.
# Suppose we obtained vector 'x' without knowing how it was generated.
set.seed(1)
nodes <- runif(10, min = 0, max = 100)
x <- lapply(nodes, function(x) rnorm(10, mean = x, sd = 0.1))
x <- unlist(x)

kluster(x) # kluster reveals the natural grouping

kluster(x, bw = 10) # adjust bandwidth depending on application

# Example with faithful dataset
faithful$k <- kluster(faithful$eruptions)
library(ggplot2)
ggplot(faithful, aes(eruptions)) +
  geom_density() +
  geom_rug(aes(color = factor(k))) +
  theme_minimal() +
  scale_color_discrete(name = "k")
}
