#' Get path to example ARD scripts, auto-generated by siera
#'
#' siera comes bundled with some example ARD-producing scripts in
#' its `inst/script` directory. This function make them easy to access.
#'
#' @param path Name of R file. If `NULL`, the example files will be listed.
#' @returns A list of example R files (if path is NULL), or a file itself if path is used.
#' @export
#' @examples
#' ARD_script_example()
#' ARD_script_example("ARD_Out14-1-1.R")
ARD_script_example <- function(path = NULL) {
  if (is.null(path)) {
    dir(system.file("script", package = "siera"))
  } else {
    system.file("script", path, package = "siera", mustWork = TRUE)
  }
}
