% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalizationFunction.R
\name{normalizeData}
\alias{normalizeData}
\title{Normalization of given data}
\usage{
normalizeData(dataInput, dataInputName = NA)
}
\arguments{
\item{dataInput}{a data frame composed of two columns. One is for time other is for intensity.}

\item{dataInputName}{experiment name (Default is 'NA').}
}
\value{
Function returns another data frame, scaling factors and scaling constants for time and intensity. The other data frame includes 2 columns one is for normalized time and the other is for noralized intensity. The whole time is distributed between 0 and 1 and similarly the whole intensity is distributed between 0 and 1. The time and intensity constants and scaling factors are the parameters to transform data from given set to scaled set.
}
\description{
Maps the given time-intensity data into a recaled frame where time is between [x,1] and intensity is between [0,1].
}
\examples{
# generateRandomData
time = seq(3,48,0.5)
intensity=runif(length(time), 3.0, 7.5)
dataInput = data.frame(time,intensity)

# Normalize Data
dataOutput = normalizeData(dataInput,dataInputName="batch_01_21_2016_samp007623")

}

