"use strict";function _typeof(obj){"@babel/helpers - typeof";return _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(obj){return typeof obj}:function(obj){return obj&&"function"==typeof Symbol&&obj.constructor===Symbol&&obj!==Symbol.prototype?"symbol":typeof obj},_typeof(obj)}function createDataEntryGrid(containerId,headers,newRowCount){var _rowCount=0;var _columnCount=0;var anchorRow=0;var anchorColumn=0;var selectionRow=0;var selectionColumn=0;var returnColumn=0;var inputBox=null;var contextMenu=null;var hiddenTextarea=null;var selecting=false;var localizedText={cut:"Cut",copy:"Copy",deleteRow:"Delete row",addRowBefore:"Add row before",addRowAfter:"Add row after",deleteColumn:"Delete column",addColumnBefore:"Add column before",addColumnAfter:"Add column after"};var rowHeaders=null;var columnsAreFlexible=false;var undo=undoSystem();function noop(){return null}var commitEdit=noop;var reunittingFunction=null;var table=function(){if(typeof containerId==="string"){var t=document.getElementById(containerId);if(t){return t}var _n=document.createElement("TABLE");_n.id=containerId}var n=document.createElement("TABLE");for(;;){var id="table-"+Math.floor(Math.random()*9000+1000);if(!document.getElementById(id)){n.id=id;return n}}}();if(!table){console.error("no such table #".concat(containerId));return null}table.classList.add("data-entry-grid");function getRow(r){return getTbody().getElementsByTagName("TR")[r]}function getCell(r,c){return getRow(r).getElementsByTagName("TD")[c]}function getRowHeader(r){return getRow(r).getElementsByTagName("TH")[0]}function getAnchor(){return getCell(anchorRow,anchorColumn)}function getColumnHeaderRow(){var thead=table.getElementsByTagName("THEAD");if(thead.length===0){return[]}var tr=thead[0].getElementsByTagName("TR");if(tr.length===0){return[]}return tr[0].getElementsByTagName("TH")}function getTextContents(array,startFrom){var r=[];for(var i=startFrom;i<array.length;++i){r.push(array[i].textContent)}return r}function getColumnHeaders(){var ths=getColumnHeaderRow();return getTextContents(ths,1)}function columnHeaderToIndexMap(){var ths=getColumnHeaderRow();var mapping={};for(var i=1;i!==ths.length;++i){mapping[ths[i].textContent]=i-1}return mapping}function getRowHeaders(){var tbody=table.getElementsByTagName("TBODY");if(tbody.length===0){return[]}var ths=tbody[0].getElementsByTagName("TH");return getTextContents(ths,0)}function forEachSubheader(f,fTd){var tds=getSubheaderTr().getElementsByTagName("TD");for(var i=0;i!==tds.length;++i){var td=tds[i];var selects=td.getElementsByTagName("SELECT");if(selects.length===0){if(fTd){fTd(td,i)}}else if(f){f(selects[0],i)}}}function getSubheaders(){var vs=[];forEachSubheader(function(s){vs.push(s.value)},function(){vs.push(null)});return vs}function hideSubheaders(){forEachSubheader(function(s){s.style.display="none"})}function setSubheaders(optionSpecs,defaultOptions){if(!optionSpecs){return}forEachSubheader(function(s,i){if(!(i in optionSpecs)||!optionSpecs[i]){s.style.display="none";return}var spec=optionSpecs[i];var values=Object.keys(spec);s.style.display="block";s.textContent="";createElementArray(s,"OPTION",values,function(opt,value){opt.textContent=spec[value];opt.value=value});reunittingFunction=null;if(defaultOptions&&i in defaultOptions&&defaultOptions[i]){s.value=defaultOptions[i]}else{s.value=values[0]}s.oldValue=s.value;s.onchange=function(){if(s.value===s.oldValue){return}var oldColumn=null;var newColumn=null;if(reunittingFunction){oldColumn=getColumn(i);newColumn=reunittingFunction(i,s.oldValue,s.value,oldColumn)}undo.undoable(setColumnAndSubheaderAction(i,s.oldValue,s.value,oldColumn,newColumn))}})}function refocus(){hiddenTextarea.focus()}function createElementArray(container,element,items,adaptFn){if(typeof container==="string"){container=document.createElement(container)}var size=items;var getItem=function getItem(index){return index};if(_typeof(items)==="object"){getItem=function getItem(index){return items[index]};size=items.length}for(var i=0;i!=size;++i){var sub=document.createElement(element);if(adaptFn){adaptFn(sub,getItem(i))}container.appendChild(sub)}return container}function createElement(tag,attributes){var e=document.createElement(tag);for(var k in attributes){e.setAttribute(k,attributes[k])}return e}var unicodeForA="A".charCodeAt(0);function flexibleColumnName(c){var u=String.fromCharCode(unicodeForA+c%26);return c<26?u:String.fromCharCode(c/26+unicodeForA-1).concat(u)}function init(headers,rows,subheaderSpecs,subheaderDefaults){if(typeof headers==="number"){columnsAreFlexible=true;var n=headers;headers=[];for(var i=0;i<n;++i){headers.push(flexibleColumnName(i))}subheaderSpecs=null;subheaderDefaults=null}else{columnsAreFlexible=false}var data=[];if(_typeof(rows)==="object"){if(0 in rows&&_typeof(rows[0])==="object"){data=rows;rows=data.length;rowHeaders=null}else{rowHeaders=rows;rows=rowHeaders.length}}else{rowHeaders=null}var thead=createElementArray("THEAD","TR",1,function(tr){tr.setAttribute("class","header");createElementArray(tr,"TH",1,function(th){var div=createElement("DIV",{style:"width:0;height:0;overflow:hidden;position:fixed;top:-99px;left:-99px;"});hiddenTextarea=createElement("TEXTAREA",{tabindex:"-1"});div.appendChild(hiddenTextarea);th.onclick=refocus;th.appendChild(div)});createElementArray(tr,"TH",headers,function(e,x){e.textContent=x;e.onclick=refocus})});createElementArray(thead,"TR",1,function(tr){tr.setAttribute("class","subheader");createElementArray(tr,"TH",1);createElementArray(tr,"TD",headers.length,function(td){createElementArray(td,"SELECT",1)})});var tbody=createElementArray("TBODY","TR",rows,function(tr,i){var rowData=data[i];var row=rowData?rowData:[];createElementArray(tr,"TH",1);createElementArray(tr,"TD",headers.length,function(td,j){if(j<row.length){td.textContent=row[j]}if(i===0&&j===0){td.setAttribute("class","anchor")}})});var oldTHeads=table.getElementsByTagName("THEAD");if(oldTHeads.length===0){table.appendChild(thead)}else{table.replaceChild(thead,oldTHeads[0])}var oldTBodies=table.getElementsByTagName("TBODY");if(oldTBodies.length===0){table.appendChild(tbody)}else{table.replaceChild(tbody,oldTBodies[0])}if(typeof subheaderSpecs==="undefined"||!subheaderSpecs){hideSubheaders()}else{setSubheaders(subheaderSpecs,subheaderDefaults)}anchorRow=0;selectionRow=0;anchorColumn=0;selectionColumn=0;_rowCount=rows;_columnCount=headers.length;undo.clearUndo();setCellMouseHandlers(0);refocus()}function removeContextMenu(menu){if(menu.parentNode){try{menu.parentNode.removeChild(menu)}catch(e){}}contextMenu=null;refocus()}function preventDefault(ev){if(ev.preventDefault){ev.preventDefault()}if(ev.stopPropagation){ev.stopPropagation()}ev.cancelBubble=true;return false}function getEvent(ev){return ev?ev:window.event}function handleInputKey(ev){ev=getEvent(ev);if(ev.keyCode===9){if(ev.shiftKey){goToPreviousCell()}else{goToNextCell()}return preventDefault(ev)}else if(ev.keyCode===13){goToNextRow();return preventDefault(ev)}return true}function beginEdit(){var r=anchorRow;var c=anchorColumn;var maxLength=3;forEachRow(0,_rowCount,function(row){forEachColumn(row,c,c+1,function(cell){var len=cell.textContent.length;if(maxLength<len){maxLength=len}})});var box=createElement("INPUT",{size:maxLength-2});var cell=getCell(r,c);var text=cell.textContent;box.value=text;cell.textContent="";cell.appendChild(box);commitEdit=function commitEdit(){return doCommitEdit(r,c,box,text)};box.onkeydown=handleInputKey;box.onblur=function(){undo.undoable(commitEdit(r,c,box,text));refocus()};box.setSelectionRange(0,box.value.length);box.focus();inputBox=box}function doCommitEdit(row,column,box,oldValue){inputBox=null;commitEdit=noop;var newValue=box.value;if(box.parentNode===null){return null}putCells(row,row+1,column,column+1,[[newValue]]);if(oldValue===newValue){return null}return function(){return putCellsAction(row,row+1,column,column+1,[[oldValue]])}}function getTbody(){var tbodies=table.getElementsByTagName("TBODY");if(tbodies.length<1){throw"No tbodies in table!"}return tbodies[0]}function insertRows(r,count){undo.undoable(commitEdit());var tbody=getTbody();var insertFunction=r<_rowCount?function(child){tbody.insertBefore(child,getRow(r))}:function(child){tbody.appendChild(child)};for(var i=0;i!==count;++i){var row=createElementArray("TR","TH",1);createElementArray(row,"TD",_columnCount);insertFunction(row)}_rowCount+=count;var selectionEndsMoved=0;if(r<=anchorRow){selectionEndsMoved+=1;anchorRow+=count}if(r<=selectionRow){selectionEndsMoved+=1;selectionRow+=count}setCellMouseHandlers(r);if(selectionEndsMoved===1){forEachRow(r,r+count,markSelectedColumns)}return function(){return deleteRows(r,count)}}function extendRows(rows){if(rowHeaders){return 0}var nr=rows-_rowCount;if(nr<=0){return 0}insertRows(_rowCount,nr);return nr}function deleteRows(r,count){undo.undoable(commitEdit());var values=getCells(r,r+count,0,_columnCount);var tbody=getTbody();for(var i=0;i!==count;++i){tbody.removeChild(tbody.children[r])}_rowCount-=count;if(r<anchorRow){if(r+count<anchorRow){anchorRow-=count}else{anchorRow=r}}if(r<selectionRow){if(r+count<selectionRow){selectionRow-=count}else{selectionRow=r}}if(_rowCount<=selectionRow){selectionRow=_rowCount-1}if(_rowCount<=anchorRow){anchorRow=_rowCount-1;_setSelection(anchorRow,anchorColumn,selectionRow,selectionColumn)}setCellMouseHandlers(r);return function(){var inverse=insertRows(r,count);putCells(r,r+count,0,_columnCount,values);return inverse}}function insertColumns(c,count){undo.undoable(commitEdit());var hrow=getHeaderTr();var shrow=getSubheaderTr();var thFn;var thFnS;if(c<_columnCount){var b=hrow.childNodes[c+1];var bs=shrow.childNodes[c+1];thFn=function thFn(child){hrow.insertBefore(child,b)};thFnS=function thFnS(child){shrow.insertBefore(child,bs)}}else{thFn=function thFn(child){hrow.appendChild(child)};thFnS=function thFnS(child){shrow.appendChild(child)}}for(var i=0;i<count;++i){thFn(document.createElement("TH"));thFnS(document.createElement("TD"))}for(var r=0;r!==_rowCount;++r){var row=getRow(r);if(c===_columnCount){for(var _i=0;_i<count;++_i){row.appendChild(document.createElement("TD"))}}else{var _b=row.childNodes[c+1];for(var _i2=0;_i2<count;++_i2){row.insertBefore(document.createElement("TD"),_b)}}}_columnCount+=count;var selectionEndsMoved=0;if(c<=anchorColumn){selectionEndsMoved+=1;anchorColumn+=count}if(c<=selectionColumn){selectionEndsMoved+=1;selectionColumn+=count}setCellMouseHandlers(0);if(selectionEndsMoved===1){var r0=Math.min(selectionRow,anchorRow);var r1=Math.max(selectionRow,anchorRow)+1;forEachRow(r0,r1,function(row){forEachColumn(row,c,c+count,function(cell){cell.classList.add("selected")})})}setFlexibleHeaderNames(c);return function(){return deleteColumns(c,count)}}function deleteColumns(c,count){undo.undoable(commitEdit());var values=getCells(0,_rowCount,c,c+count);var hrow=getHeaderTr();var shrow=getSubheaderTr();for(var i=0;i!==count;++i){hrow.removeChild(hrow.childNodes[c+1]);shrow.removeChild(shrow.childNodes[c+1])}for(var r=0;r!==_rowCount;++r){var row=getRow(r);for(var _i3=0;_i3<count;++_i3){row.removeChild(row.childNodes[c+1])}}_columnCount-=count;if(c<anchorColumn){if(c+count<anchorColumn){anchorColumn-=count}else{anchorColumn=c}}if(c<selectionColumn){if(c+count<selectionColumn){selectionColumn-=count}else{selectionColumn=c}}if(_columnCount<=selectionColumn){selectionColumn=_columnCount-1}if(_columnCount<=anchorColumn){anchorColumn=_columnCount-1;_setSelection(anchorRow,anchorColumn,selectionRow,selectionColumn)}setCellMouseHandlers(0);setFlexibleHeaderNames(c);return function(){var inverse=insertColumns(c,count);putCells(0,_rowCount,c,c+count,values);return inverse}}function setFlexibleHeaderNames(c){var hrow=getHeaderTr();for(var i=c;i<_columnCount;++i){hrow.childNodes[i+1].textContent=flexibleColumnName(i)}}function getHeaderTr(){var thead=table.getElementsByTagName("THEAD")[0];return thead.getElementsByTagName("TR")[0]}function getSubheaderTr(){var thead=table.getElementsByTagName("THEAD")[0];return thead.getElementsByTagName("TR")[1]}function markSelectedColumns(row){forEachSelectedColumn(row,function(cell){cell.classList.add("selected")})}function _setSelection(aRow,aColumn,sRow,sColumn){getAnchor().classList.remove("anchor");forEachSelectedRow(function(row){forEachSelectedColumn(row,function(cell){cell.classList.remove("selected")})});anchorRow=aRow;anchorColumn=aColumn;selectionRow=sRow;selectionColumn=sColumn;forEachSelectedRow(function(row){markSelectedColumns(row)});getAnchor().classList.add("anchor")}function doGoToCell(r,c){undo.undoable(commitEdit());getAnchor().classList.remove("anchor");if(r<0||_rowCount<=r||c<0||_columnCount<=c){return}_setSelection(r,c,r,c);getAnchor().classList.add("anchor");beginEdit()}function goToNextRow(){if(_rowCount<=anchorRow+1){if(rowHeaders){doGoToCell(anchorRow,returnColumn);return}undo.undoable(insertRows(_rowCount,1))}doGoToCell(anchorRow+1,returnColumn)}function goToPreviousCell(){doGoToCell(anchorRow,anchorColumn-1)}function goToNextCell(){if(anchorColumn+1<_columnCount){doGoToCell(anchorRow,anchorColumn+1)}else{goToNextRow()}}function goToCell(r,c){returnColumn=c;doGoToCell(r,c)}function addOption(menu,id,callback,text,disabled){var attrs={value:id};if(disabled){attrs.disabled=true}var e=createElement("OPTION",attrs);e.textContent=text;e.onclick=callback;menu.appendChild(e)}function addRowsOptions(menu,firstRow,count){addOption(menu,"delete",function(){undo.undoable(deleteRows(firstRow,count));removeContextMenu(menu)},localizedText.deleteRow,count===_rowCount);addOption(menu,"add-before",function(){undo.undoable(insertRows(firstRow,count));removeContextMenu(menu)},localizedText.addRowBefore);addOption(menu,"add-after",function(){undo.undoable(insertRows(firstRow+count,count));removeContextMenu(menu)},localizedText.addRowAfter)}function addColumnsOptions(menu,firstColumn,count){addOption(menu,"column-delete",function(){undo.undoable(deleteColumns(firstColumn,count));removeContextMenu(menu)},localizedText.deleteColumn,count===_columnCount);addOption(menu,"column-add-before",function(){undo.undoable(insertColumns(firstColumn,count));removeContextMenu(menu)},localizedText.addColumnBefore);addOption(menu,"column-add-after",function(){undo.undoable(insertColumns(firstColumn+count,count));removeContextMenu(menu)},localizedText.addColumnAfter)}function addClipboardOptions(menu){var cb=window.navigator.clipboard;addOption(menu,"cut",function(){if(cb&&cb.writeText){cb.writeText(copySelection()).then(clearSelection)}else{document.execCommand("cut")}removeContextMenu(menu);refocus()},localizedText.cut);addOption(menu,"copy",function(){if(cb&&cb.writeText){cb.writeText(copySelection())}else{document.execCommand("copy")}removeContextMenu(menu);refocus()},localizedText.copy)}function emptyContextMenu(size){return createElement("SELECT",{id:table.getAttribute("id").concat("-context-menu"),size:size})}function rowHeaderMenu(ev,r){var r1=Math.min(anchorRow,selectionRow);var rc=Math.abs(selectionRow-anchorRow)+1;if(r<r1||r1+rc<=r){r1=r;rc=1;_setSelection(r,0,r,_columnCount-1)}var menu=emptyContextMenu(rowHeaders?2:5);if(!rowHeaders){addRowsOptions(menu,r1,rc)}addClipboardOptions(menu);attachContextMenu(ev,menu);return menu}function columnHeaderMenu(ev,c){var menu=emptyContextMenu(columnsAreFlexible?5:2);if(columnsAreFlexible){var c1=Math.min(anchorColumn,selectionColumn);var cc=Math.abs(selectionColumn-anchorColumn)+1;if(c<c1||c1+cc<=c){c1=c;cc=1;_setSelection(0,c,_rowCount-1,c)}addColumnsOptions(menu,c1,cc)}addClipboardOptions(menu);attachContextMenu(ev,menu);return menu}function cellContextMenu(ev,r,c){var r1=Math.min(anchorRow,selectionRow);var rc=Math.abs(selectionRow-anchorRow)+1;var c1=Math.min(anchorColumn,selectionColumn);var cc=Math.abs(selectionColumn-anchorColumn)+1;if(r<r1||r1+rc<=r||c<c1||c1+cc<=c){r1=r;rc=1;c1=c;cc=1;_setSelection(r,c,r,c)}var menuItemsCount=2;if(columnsAreFlexible){menuItemsCount+=3}if(!rowHeaders){menuItemsCount+=3}var menu=emptyContextMenu(menuItemsCount);if(!rowHeaders){addRowsOptions(menu,r1,rc)}if(columnsAreFlexible){addColumnsOptions(menu,c1,cc)}addClipboardOptions(menu);attachContextMenu(ev,menu);return menu}function tableHeaderMenu(ev){var menu=emptyContextMenu(2);addClipboardOptions(menu);attachContextMenu(ev,menu);return menu}function getMouseCoordinates(ev){for(var e=table;e;e=e.parentElement){var s=window.getComputedStyle(e).getPropertyValue("position");if(s!=="static"){var r=e.getBoundingClientRect(e);return{x:ev.clientX-r.left+e.scrollLeft,y:ev.clientY-r.top+e.scrollTop}}}return{x:ev.pageX,y:ev.pageY}}function attachContextMenu(ev,menu){var mousePosition=getMouseCoordinates(ev);menu.style.position="absolute";menu.style.left=mousePosition.x+"px";menu.style.top=mousePosition.y+"px";menu.tabIndex=-1;menu.zIndex=10;menu.onblur=function(){removeContextMenu(menu)};menu.contentEditable=false;if(contextMenu){removeContextMenu(contextMenu)}contextMenu=menu;table.appendChild(menu);menu.focus()}function forEachRow(rowStart,rowEnd,callback){var rows=getTbody().getElementsByTagName("TR");var rEnd=(rows.length<rowEnd?rows.length:rowEnd)-rowStart;for(var i=0;i<rEnd;++i){callback(rows[rowStart+i],i,rowStart+i)}}function forEachColumn(row,columnStart,columnEnd,callback){var cs=row.getElementsByTagName("TD");var cEnd=(cs.length<columnEnd?cs.length:columnEnd)-columnStart;for(var i=0;i<cEnd;++i){callback(cs[columnStart+i],i,columnStart+i)}}function forEachSelectedRow(callback){forEachRow(Math.min(anchorRow,selectionRow),Math.max(anchorRow,selectionRow)+1,callback)}function forEachSelectedColumn(row,callback){forEachColumn(row,Math.min(anchorColumn,selectionColumn),Math.max(anchorColumn,selectionColumn)+1,callback)}function setCellMouseHandlers(firstRow){var chr=getColumnHeaderRow();if(chr.length){var h=chr[0];h.onmousedown=function(){_setSelection(0,0,_rowCount-1,_columnCount-1);refocus()};h.oncontextmenu=function(ev){ev=getEvent(ev);tableHeaderMenu(ev).focus();return preventDefault(ev)}}var _loop=function _loop(i){var thisColumn=i-1;var h=chr[i];var c=i-1;h.onmousedown=function(ev){if(ev.button===0){undo.undoable(commitEdit());_setSelection(0,c,_rowCount-1,c);refocus();ev.preventDefault()}};h.onmouseenter=function(ev){ev=getEvent(ev);if(selecting&&ev.buttons&1){var r=anchorRow===0?_rowCount-1:0;_setSelection(anchorRow,anchorColumn,r,thisColumn);scrollToCell(r,thisColumn,anchorRow,anchorColumn);refocus();return preventDefault(ev)}};h.oncontextmenu=function(ev){ev=getEvent(ev);columnHeaderMenu(ev,thisColumn).focus();return preventDefault(ev)}};for(var i=1;i<chr.length;++i){_loop(i)}forEachRow(firstRow,_rowCount,function(row,i,thisRow){var headers=row.getElementsByTagName("TH");if(0<headers.length){var rh=headers[0];rh.textContent=rowHeaders?rowHeaders[thisRow]:thisRow+1;rh.onmousedown=function(ev){ev=getEvent(ev);if(ev.button===0){_setSelection(thisRow,0,thisRow,_columnCount-1);refocus();ev.preventDefault()}};rh.onmouseenter=function(ev){ev=getEvent(ev);if(selecting&&ev.buttons&1){var c=anchorColumn===0?_columnCount-1:0;_setSelection(anchorRow,anchorColumn,thisRow,c);scrollToCell(thisRow,c,anchorRow,anchorColumn);refocus();return preventDefault(ev)}};rh.oncontextmenu=function(ev){ev=getEvent(ev);rowHeaderMenu(ev,thisRow).focus();return preventDefault(ev)};forEachColumn(row,0,_columnCount,function(cell,j,thisColumn){cell.onclick=function(){goToCell(thisRow,thisColumn)};cell.onmouseenter=function(ev){ev=getEvent(ev);if(selecting&&ev.buttons&1){_setSelection(anchorRow,anchorColumn,thisRow,thisColumn);scrollToCell(thisRow,thisColumn,anchorRow,anchorColumn);refocus();return preventDefault(ev)}};cell.onmousedown=function(ev){ev=getEvent(ev);if(ev.button===0){undo.undoable(commitEdit());_setSelection(thisRow,thisColumn,thisRow,thisColumn);refocus();ev.preventDefault()}};cell.oncontextmenu=function(ev){ev=getEvent(ev);cellContextMenu(ev,thisRow,thisColumn).focus();return preventDefault(ev)}})}})}function getCellContents(cell){var inputs=cell.getElementsByTagName("INPUT");if(0<inputs.length){return inputs[0].value}return cell.textContent}function withDefault(a,def){return typeof a==="undefined"?def:a}function getCells(rowStart,rowEnd,columnStart,columnEnd){var vss=[];forEachRow(withDefault(rowStart,0),withDefault(rowEnd,_rowCount),function(row){var vs=[];forEachColumn(row,withDefault(columnStart,0),withDefault(columnEnd,_columnCount),function(cell){vs.push(getCellContents(cell))});vss.push(vs)});return vss}function putCells(rowStart,rowEnd,columnStart,columnEnd,values){forEachRow(rowStart,rowEnd,function(row,i){var vr=values[i];forEachColumn(row,columnStart,columnEnd,function(cell,j){cell.textContent=typeof vr==="undefined"?"":vr[j]})})}function putCellsAction(rowStart,rowEnd,columnStart,columnEnd,values){var oldValues=getCells(rowStart,rowEnd,columnStart,columnEnd);putCells(rowStart,rowEnd,columnStart,columnEnd,values);_setSelection(rowStart,columnStart,rowEnd-1,columnEnd-1);return function(){return putCellsAction(rowStart,rowEnd,columnStart,columnEnd,oldValues)}}function setColumnAndSubheaderAction(columnIndex,oldValue,newValue,oldColumn,newColumn){if(newColumn){forEachRow(0,_rowCount,function(row,i){forEachColumn(row,columnIndex,columnIndex+1,function(cell){cell.textContent=newColumn[i]})})}var tds=getSubheaderTr().getElementsByTagName("TD");if(columnIndex<tds.length){var selects=tds[columnIndex].getElementsByTagName("SELECT");if(selects.length!==0){selects[0].value=newValue;selects[0].oldValue=newValue}}return function(){return setColumnAndSubheaderAction(columnIndex,newValue,oldValue,newColumn,oldColumn)}}function doUndo(){undo.undoable(commitEdit());undo.undo();refocus()}function doRedo(){commitEdit();undo.redo();refocus()}function clearCells(startRow,endRow,startColumn,endColumn){var row=[];for(var i=startColumn;i!==endColumn;++i){row.push("")}var empties=[];for(var j=startRow;j!==endRow;++j){empties.push(row)}undo.undoable(putCellsAction(startRow,endRow,startColumn,endColumn,empties))}function clearSelection(){var firstRow=Math.min(anchorRow,selectionRow);var lastRow=Math.max(anchorRow,selectionRow)+1;var firstColumn=Math.min(anchorColumn,selectionColumn);var lastColumn=Math.max(anchorColumn,selectionColumn)+1;clearCells(firstRow,lastRow,firstColumn,lastColumn)}function copySelection(){var texts=[];forEachSelectedRow(function(row){var rowTexts=[];forEachSelectedColumn(row,function(cell){var inputs=cell.getElementsByTagName("INPUT");if(0<inputs.length){rowTexts.push(inputs[0].value)}else{rowTexts.push(cell.textContent)}});texts.push(rowTexts.join("\t"))});return texts.join("\n")}function paste(clip){if(clip.length===0){return}var values=[];var maxRowLength=0;var lines=clip.split("\n");if(lines[lines.length-1].length===0){lines.pop()}for(var i=0;i!==lines.length;++i){var row=lines[i].split("\t");values.push(row);if(maxRowLength<row.length){maxRowLength=row.length}}var firstRow=Math.min(anchorRow,selectionRow);var lastRow=Math.max(anchorRow,selectionRow)+1;var firstColumn=Math.min(anchorColumn,selectionColumn);var lastColumn=Math.max(anchorColumn,selectionColumn)+1;if(lastColumn<firstColumn+maxRowLength){lastColumn=firstColumn+maxRowLength;if(_columnCount<lastColumn&&columnsAreFlexible){undo.undoable(insertColumns(_columnCount,lastColumn-_columnCount))}}if(lastRow<firstRow+values.length){lastRow=firstRow+values.length;if(_rowCount<lastRow&&!rowHeaders){undo.undoable(insertRows(_rowCount,lastRow-_rowCount))}}for(var c=firstColumn+maxRowLength;c<lastColumn;++c){var source=c%maxRowLength;for(var r=0;r!==values.length;++r){values[r][c-firstColumn]=values[r][source]}}var valueRowCount=values.length;var wantedRowCount=lastRow-firstRow;for(var _r=valueRowCount;_r<wantedRowCount;++_r){values[_r]=values[_r%valueRowCount]}undo.undoable(putCellsAction(firstRow,lastRow,firstColumn,lastColumn,values))}function tableKeyPressHandler(ev){ev=getEvent(ev);if(contextMenu){return}if(!inputBox){beginEdit();var cc=ev.charCode||ev.keyCode;if(31<cc){inputBox.value=String.fromCharCode(cc)}return preventDefault(ev)}}function tableCutHandler(ev){ev=getEvent(ev);var text=copySelection();ev.clipboardData.setData("text/plain",text);clearSelection();refocus();return preventDefault(ev)}function tableCopyHandler(ev){ev=getEvent(ev);var text=copySelection();ev.clipboardData.setData("text/plain",text);return preventDefault(ev)}function tablePasteHandler(ev){ev=getEvent(ev);if(0<=ev.clipboardData.types.indexOf("text/plain")){try{paste(ev.clipboardData.getData("text/plain"))}catch(err){console.warn(err)}}refocus();return preventDefault(ev)}function tableKeyDownHandler(ev){ev=getEvent(ev);if(contextMenu){if(ev.key==="Escape"){refocus()}if(ev.key==="Enter"||ev.key===" "){var index=contextMenu.selectedIndex;if(0<=index){var options=contextMenu.getElementsByTagName("OPTION");options[index].onclick();return preventDefault(ev)}}return}if((ev.ctrlKey||ev.metaKey)&&!ev.altKey){if(ev.keyCode===90){if(ev.shiftKey){doRedo()}else{doUndo()}return preventDefault(ev)}}if(!inputBox&&(ev.key==="Delete"||ev.key==="Backspace")){clearSelection();return preventDefault(ev)}if(moveSelection(ev)===false){undo.undoable(commitEdit());refocus();return preventDefault(ev)}if(moveAnchor(ev)===false){return preventDefault(ev)}}function moveAnchor(ev){if(ev.shiftKey||ev.altKey||ev.metaKey){return}var inputNotSelected=inputBox&&inputBox.selectionStart===inputBox.selectionEnd;var inputAtStart=inputNotSelected&&inputBox.selectionStart===0;var inputAtEnd=inputNotSelected&&inputBox.selectionStart===inputBox.value.length;var dest=null;if(ev.key==="ArrowLeft"){if((!inputBox||inputAtStart)&&0<anchorColumn){dest={row:anchorRow,column:anchorColumn-1}}}else if(ev.key==="ArrowRight"){if((!inputBox||inputAtEnd)&&anchorColumn+1<_columnCount){dest={row:anchorRow,column:anchorColumn+1}}}else{dest=move(ev,anchorRow,anchorColumn)}if(dest){var change=undo.undoable(commitEdit());scrollToCell(dest.row,dest.column,anchorRow,anchorColumn);_setSelection(dest.row,dest.column,dest.row,dest.column);returnColumn=anchorColumn;beginEdit();return false}}function move(ev,row,column){var here={row:row,column:column};if(ev.key==="ArrowUp"){if(0<row){return{row:row-1,column:column}}return here}if(ev.key==="ArrowDown"){if(row+1<_rowCount){return{row:row+1,column:column}}return here}if(ev.key==="ArrowLeft"){if(0<column){return{row:row,column:column-1}}return here}if(ev.key==="ArrowRight"){if(column+1<_columnCount){return{row:row,column:column+1}}return here}if(ev.key==="Home"){return ev.ctrlKey?{row:0,column:0}:{row:row,column:0}}if(ev.key==="End"){column=_columnCount-1;return ev.ctrlKey?{row:_rowCount-1,column:column}:{row:row,column:column}}if(ev.key==="PageUp"){return{row:Math.max(0,row-rowsVisibleCount()),column:column}}if(ev.key==="PageDown"){return{row:Math.min(_rowCount-1,row+rowsVisibleCount()),column:column}}return null}function rowsVisibleCount(){var frameHeight=Math.max(1,window.innerHeight);var rowPixels=Math.max(getAnchor().offsetHeight,1);forEachScrollableAncestor(table,noop,function(el,rect){frameHeight=Math.min(frameHeight,rect.bottom-rect.top)});return Math.max(Math.floor(frameHeight/rowPixels-1),2)}function compare(value,against){return value===against?0:value<against?-1:1}function isScrollable(element,direction){var style=window.getComputedStyle(element);var overflow=style.getPropertyValue("overflow-".concat(direction));if(!overflow){overflow=style.getPropertyValue("overflow")}return overflow==="auto"||overflow==="scroll"}function getBoundingRect(element){var r=element.getBoundingClientRect();var left=r.left+element.clientLeft;var top=r.top+element.clientTop;return{left:left,right:left+element.clientWidth,top:top,bottom:top+element.clientHeight}}function forEachScrollableAncestor(el,xScrollFn,yScrollFn){el=el.parentNode;while(el){if(el instanceof HTMLElement){var rect=null;if(isScrollable(el,"x")){if(!rect){rect=getBoundingRect(el)}xScrollFn(el,rect)}if(isScrollable(el,"y")){if(!rect){rect=getBoundingRect(el)}yScrollFn(el,rect)}}el=el.parentNode}}function scrollIntoView(el){var eltRect=getBoundingRect(el);forEachScrollableAncestor(el,function(el,rect){var xScroll=0;if(eltRect.left<rect.left){xScroll=eltRect.left-rect.left}else if(rect.right<eltRect.right){xScroll=eltRect.right-rect.right}if(xScroll){el.scrollLeft+=xScroll;eltRect.left-=xScroll;eltRect.right-=xScroll}},function(el,rect){var yScroll=0;if(eltRect.top<rect.top){yScroll=eltRect.top-rect.top}else if(rect.bottom<eltRect.bottom){yScroll=eltRect.bottom-rect.bottom}if(yScroll){el.scrollTop+=yScroll;eltRect.top-=yScroll;eltRect.bottom-=yScroll}})}function scrollToCell(toRow,toColumn,fromRow,fromColumn){var cell=getCell(toRow,toColumn);var br0=toRow+compare(toRow,fromRow);var br=clampRow(br0);var bc0=toColumn===0?-1:toColumn+compare(toColumn,fromColumn);var bc=clampColumn(bc0);var cell2=br0===-1?getColumnHeaderRow()[bc0+1]:bc0===-1?getRowHeader(br):getCell(br,bc);scrollIntoView(cell2);scrollIntoView(cell)}function moveSelection(ev){if(!ev.shiftKey||ev.altKey||ev.metaKey){return}var dest=move(ev,selectionRow,selectionColumn);if(dest){_setSelection(anchorRow,anchorColumn,dest.row,dest.column);scrollToCell(dest.row,dest.column,anchorRow,anchorColumn);return false}}function getColumn(column){var vs=[];forEachRow(0,_rowCount,function(row){forEachColumn(row,column,column+1,function(cell){vs.push(getCellContents(cell))})});return vs}function clampRow(r){return r<0?0:_rowCount<=r?_rowCount-1:r}function clampColumn(c){return c<0?0:_columnCount<=c?_columnCount-1:c}function rowsRequiredForColumns(columns){var rowsRequired=0;if(rowHeaders){return _rowCount}for(var k in columns){rowsRequired=Math.max(rowsRequired,columns[k].length)}return rowsRequired}table.onkeydown=tableKeyDownHandler;table.onkeypress=tableKeyPressHandler;table.oncut=tableCutHandler;table.oncopy=tableCopyHandler;table.onpaste=tablePasteHandler;table.onmousemove=function(ev){ev=getEvent(ev);if(selecting&&ev.buttons&1){ev.preventDefault()}};table.onmousedown=function(ev){ev=getEvent(ev);if(ev.button===0){selecting=true}};table.onmouseup=function(ev){selecting=false};init(headers,newRowCount);refocus();table.dataEntryGrid={init:init,setSubheaderTooltip:function setSubheaderTooltip(index,text){forEachSubheader(function(elt,i){if(i==index){elt.setAttribute("title",text)}})},setSubheaderOptionTooltip:function setSubheaderOptionTooltip(index,optionName,text){forEachSubheader(function(elt,i){if(i==index){var options=elt.getElementsByTagName("OPTION");for(var j in options){var option=options[j];if(option.value==optionName){option.setAttribute("title",text)}}}})},extendRows:extendRows,setText:function setText(newText){for(var k in localizedText){if(k in newText){localizedText[k]=newText[k]}}},setButtons:function setButtons(undoButton,redoButton){undo.setButtons(undoButton,redoButton,refocus)},getSelection:function getSelection(){return{anchorRow:anchorRow,anchorColumn:anchorColumn,selectionRow:selectionRow,selectionColumn:selectionColumn}},setSelection:function setSelection(anchorRow,anchorColumn,selectionRow,selectionColumn){_setSelection(clampRow(anchorRow),clampColumn(anchorColumn),clampRow(withDefault(selectionRow,anchorRow)),clampColumn(withDefault(selectionColumn,anchorColumn)))},rowCount:function rowCount(){return _rowCount},columnCount:function columnCount(){return _columnCount},getColumnHeaders:getColumnHeaders,getRowHeaders:getRowHeaders,getSubheaders:getSubheaders,setReunittingFunction:function setReunittingFunction(fn){reunittingFunction=fn},goToCell:goToCell,getCells:getCells,putCells:function putCells(rowStart,rowEnd,columnStart,columnEnd,values){undo.undoable(putCellsAction(rowStart,rowEnd,columnStart,columnEnd,values))},clearData:function clearData(){clearCells(0,_rowCount,0,_columnCount)},getColumn:getColumn,getColumnArray:function getColumnArray(){var out=new Array(_columnCount);for(var i=0;i!==_columnCount;++i){out[i]=new Array}forEachRow(0,_rowCount,function(row){forEachColumn(row,0,_columnCount,function(cell,c){out[c].push(cell.textContent)})});return out},getColumns:function getColumns(columns){if(_typeof(columns)!=="object"){columns=getColumnHeaders()}var h2i=columnHeaderToIndexMap();var out={};for(var i in columns){var c=columns[i];if(typeof c==="number"||c in h2i){out[c]=[]}}forEachRow(0,_rowCount,function(row){var cells=row.getElementsByTagName("TD");for(var _i4 in columns){var _c=columns[_i4];var index=typeof _c==="number"?_c:h2i[_c];var cell=cells[index];if(typeof cell!=="undefined"){out[_c].push(cell.textContent)}}});return out},setColumns:function setColumns(columns){var rowsRequired=rowsRequiredForColumns(columns);extendRows(rowsRequired);var h2i=columnHeaderToIndexMap();forEachRow(0,_rowCount,function(row,r){var cells=row.getElementsByTagName("TD");for(var k in columns){if(k in h2i){var cell=cells[h2i[k]];var column=columns[k];var v=column[r];cell.textContent=typeof v==="undefined"?"":v}}})},setColumnArray:function setColumnArray(columns){var rowsRequired=rowsRequiredForColumns(columns);extendRows(rowsRequired);if(rowsRequired<_rowCount){deleteRows(rowsRequired,_rowCount-rowsRequired)}forEachRow(0,_rowCount,function(row,r){var cells=row.getElementsByTagName("TD");for(var k in columns){var column=columns[k];var cell=cells[k];var v=column[r];cell.textContent=typeof v==="undefined"?"":v}});undo.clearUndo()},clearUndo:function clearUndo(){return undo.clearUndo()},undo:function undo(){return doUndo()},redo:function redo(){return doRedo()},addWatcher:function addWatcher(watcher){return undo.addWatcher(watcher)},getTable:function getTable(){return table}};return table.dataEntryGrid};
"use strict";function undoSystem(){var undoStack=[];var redoStack=[];var undoButton=null;var redoButton=null;var watchers=[];function callWatchers(){for(var i=0;i!=watchers.length;++i){watchers[i]()}}function undoable(action){if(action===null){return false}if(redoButton&&redoStack.length!==0){redoButton.setAttribute("disabled","")}if(undoButton&&undoStack.length===0){undoButton.removeAttribute("disabled")}undoStack.push(action);redoStack=[];callWatchers();return true}function redo(){if(redoStack.length!==0){var action=redoStack.pop()();if(redoButton&&redoStack.length===0){redoButton.setAttribute("disabled","")}if(action!==null){if(undoButton&&undoStack.length===0){undoButton.removeAttribute("disabled")}undoStack.push(action);callWatchers()}}}function undo(){if(undoStack.length!==0){var action=undoStack.pop()();if(undoButton&&undoStack.length===0){undoButton.setAttribute("disabled","")}if(action!==null){if(redoButton&&redoStack.length===0){redoButton.removeAttribute("disabled")}redoStack.push(action);callWatchers()}}}function clearUndo(){if(redoButton&&redoStack.length!==0){redoButton.setAttribute("disabled","")}if(undoButton&&undoStack.length!==0){undoButton.setAttribute("disabled","")}redoStack=[];undoStack=[];callWatchers()}function setButtons(anUndoButton,aRedoButton,afterFn){undoButton=anUndoButton;redoButton=aRedoButton;if(undoButton){undoButton.onclick=afterFn?function(){undo();afterFn()}:undo;if(undoStack.length===0){undoButton.setAttribute("disabled","")}else{undoButton.removeAttribute("disabled")}}if(redoButton){redoButton.onclick=afterFn?function(){redo();afterFn()}:redo;if(redoStack.length===0){redoButton.setAttribute("disabled","")}else{redoButton.removeAttribute("disabled")}}}function addWatcher(f){watchers.push(f)}return{undoable:undoable,setButtons:setButtons,clearUndo:clearUndo,undo:undo,redo:redo,addWatcher:addWatcher}};
