% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/colourInput.R
\name{updateColourInput}
\alias{updateColourInput}
\title{Change the value of a colour input}
\usage{
updateColourInput(session, inputId, label = NULL, value = NULL,
  showColour = NULL, allowTransparent = NULL, transparentText = NULL)
}
\arguments{
\item{session}{The \code{session} object passed to function given to \code{shinyServer}.}

\item{inputId}{The id of the colour input object.}

\item{label}{The label to set for the input object.}

\item{value}{The value to set for the input object.}

\item{showColour}{Whether to shoW the chosen colour via text, background, or both.}

\item{allowTransparent}{If \code{TRUE}, then add a checkbox that allows the
user to select the \code{transparent} colour.}

\item{transparentText}{The text to show beside the transparency checkbox
when \code{allowTransparent} is \code{TRUE}}
}
\description{
Change the value of a colour input on the client.
}
\details{
The update function sends a message to the client, telling it to change
the settings of a colour input object.\cr
This function works similarly to the update functions provided by shiny.\cr
Any argument with \code{NULL} values will be ignored.
}
\note{
Unlike the rest of the \code{shinyjs} functions, this function does
not require you to call \code{useShinyjs()} first.

See \href{http://daattali.com/shiny/colourInput/}{http://daattali.com/shiny/colourInput/}
for a live demo.
}
\examples{
if (interactive()) {
  shiny::shinyApp(
    ui = shiny::fluidPage(
      shiny::div("Selected colour:",
                 shiny::textOutput("value", inline = TRUE)),
      colourInput("col", "Choose colour", "red"),
      shiny::h3("Update colour input"),
      shiny::textInput("text", "New colour: (colour name or HEX value)"),
      shiny::selectInput("showColour", "Show colour",
        c("both", "text", "background")),
      shiny::checkboxInput("allowTransparent", "Allow transparent", FALSE),
      shiny::actionButton("btn", "Update")
    ),
    server = function(input, output, session) {
      shiny::observeEvent(input$btn, {
        updateColourInput(session, "col",
          value = input$text, showColour = input$showColour,
          allowTransparent = input$allowTransparent)
      })
      output$value <- shiny::renderText(input$col)
    }
  )
}
}
\seealso{
\code{\link[shinyjs]{colourInput}}
}

