% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shinyfilter.r
\name{use_tooltips}
\alias{use_tooltips}
\title{Add tooltip functionality to the app}
\usage{
use_tooltips(
  background = "#000000",
  foreground = "#FFFFFF",
  textalign = "left",
  fontsize = "100\%",
  opacity = 0.8
)
}
\arguments{
\item{background}{Background color of the tooltips/popovers the in CSS hex
format.}

\item{foreground}{Font color of the tooltips/popovers the in CSS hex format.}

\item{textalign}{Alignment of the text in the tooltips/popovers; either
\code{"left"}, \code{"right"}, \code{"center"} or \code{"justify"}.}

\item{fontsize}{Font size of the tooltips/popovers.}

\item{opacity}{Opacity of the tooltips/popovers.}
}
\value{
No return value.
}
\description{
Prepares the application for the use of tooltips or popovers to
  show the (un)available filter options. \code{use_tooltips()} needs to be
  called from within the UI definition of your shiny app. See
  \code{\link{update_tooltips}()} for how to create the actual tooltips or
  popovers.
}
\details{
For a full example of a shiny app using \code{shinyfilter} please
  call up the help for \code{\link{update_filters}()}. See the
  \code{README.md} file or the GitHub repo on
  \href{https://github.com/jsugarelli/shinyfilter}{https://github.com/jsugarelli/shinyfilter}
   for a comprehensive \code{shinyfilter} tutorial.
}
