% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxes.R
\name{tabBox}
\alias{tabBox}
\title{Create a tabbed box}
\usage{
tabBox(..., id = NULL, selected = NULL, title = NULL, width = 6,
  height = NULL, side = c("left", "right"))
}
\arguments{
\item{...}{\code{\link{tabPanel}} elements to include in the tabset}

\item{id}{If provided, you can use \code{input$}\emph{\code{id}} in your
server logic to determine which of the current tabs is active. The value
will correspond to the \code{value} argument that is passed to
\code{\link{tabPanel}}.}

\item{selected}{The \code{value} (or, if none was supplied, the \code{title})
of the tab that should be selected by default. If \code{NULL}, the first
tab will be selected.}

\item{title}{Title for the tabBox.}

\item{width}{The width of the box, using the Bootstrap grid system. This is
used for row-based layouts. The overall width of a region is 12, so the
default valueBox width of 4 occupies 1/3 of that width. For column-based
layouts, use \code{NULL} for the width; the width is set by the column that
contains the box.}

\item{height}{The height of a box, in pixels or other CSS unit. By default
the height scales automatically with the content.}

\item{side}{Which side of the box the tabs should be on (\code{"left"} or
\code{"right"}). When \code{side="right"}, the order of tabs will be
reversed.}
}
\description{
Create a tabbed box
}
\examples{
## Only run this example in interactive R sessions
if (interactive()) {
library(shiny)

body <- dashboardBody(
  fluidRow(
    tabBox(
      title = "First tabBox",
      # The id lets us use input$tabset1 on the server to find the current tab
      id = "tabset1", height = "250px",
      tabPanel("Tab1", "First tab content"),
      tabPanel("Tab2", "Tab content 2")
    ),
    tabBox(
      side = "right", height = "250px",
      selected = "Tab3",
      tabPanel("Tab1", "Tab content 1"),
      tabPanel("Tab2", "Tab content 2"),
      tabPanel("Tab3", "Note that when side=right, the tab order is reversed.")
    )
  ),
  fluidRow(
    tabBox(
      # Title can include an icon
      title = tagList(shiny::icon("gear"), "tabBox status"),
      tabPanel("Tab1",
        "Currently selected tab from first box:",
        verbatimTextOutput("tabset1Selected")
      ),
      tabPanel("Tab2", "Tab content 2")
    )
  )
)

shinyApp(
  ui = dashboardPage(dashboardHeader(title = "tabBoxes"), dashboardSidebar(), body),
  server = function(input, output) {
    # The currently selected tab from the first box
    output$tabset1Selected <- renderText({
      input$tabset1
    })
  }
)
}
}
\seealso{
Other boxes: \code{\link{box}}, \code{\link{infoBox}},
  \code{\link{valueBox}}
}

