% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slim-select.R
\name{updateSlimSelect}
\alias{updateSlimSelect}
\title{Update slim select from server}
\usage{
updateSlimSelect(
  inputId,
  label = NULL,
  choices = NULL,
  selected = NULL,
  disable = NULL,
  open = NULL,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{label}{Display label for the control, or \code{NULL} for no label.}

\item{choices}{List of values to select from.
You can use:
\itemize{
\item \code{vector} a simple vector.
\item \verb{named list} / \verb{named vector} in the same way as with \code{\link[shiny:selectInput]{shiny::selectInput()}}
\item cuxtom choices prepared with \code{\link[=prepare_slim_choices]{prepare_slim_choices()}}.
}}

\item{selected}{The initially selected value (or multiple values if \code{multiple = TRUE}). If not specified then defaults to the first value for
single-select lists and no values for multiple select lists.}

\item{disable}{Disable (\code{TRUE}) or enable (\code{FALSE}) the select menu.}

\item{open}{Open (\code{TRUE}) or close (\code{FALSE}) the dropdown.}

\item{session}{The \code{session} object passed to function given to
\code{shinyServer}. Default is \code{getDefaultReactiveDomain()}.}
}
\value{
No value.
}
\description{
Update a \code{\link[=slimSelectInput]{slimSelectInput()}} from the server.
}
\examples{
library(shiny)
library(shinyWidgets)

ui <- fluidPage(
  tags$h2("Slim Select (update)"),

  slimSelectInput(
    inputId = "sel1",
    label = "Update label:",
    choices = month.name
  ),
  verbatimTextOutput("res1"),
  textInput("label_text", label = "With text:"),
  textInput("label_html", label = "With HTML:"),

  slimSelectInput(
    inputId = "sel2",
    label = "Update selected value:",
    choices = month.name
  ),
  verbatimTextOutput("res2"),
  radioButtons("selected", "Selected value:", month.name, inline = TRUE),

  slimSelectInput(
    inputId = "sel3",
    label = "Update choices:",
    choices = tolower(month.name)
  ),
  verbatimTextOutput("res3"),
  radioButtons("choices", "Choices:", c("lowercase", "UPPERCASE"), inline = TRUE),

  slimSelectInput(
    inputId = "sel4",
    label = "Update choices + selected:",
    choices = tolower(month.name)
  ),
  verbatimTextOutput("res4"),
  radioButtons("choices_select", "Choices:", c("lowercase", "UPPERCASE"), inline = TRUE),

  slimSelectInput(
    inputId = "sel5",
    label = "Disable / enable:",
    choices = tolower(month.name)
  ),
  verbatimTextOutput("res5"),
  checkboxInput("disable", "Disable", value = FALSE),

  slimSelectInput(
    inputId = "sel6",
    label = "Open / close:",
    choices = tolower(month.name)
  ),
  verbatimTextOutput("res6"),
  checkboxInput("open", "Open?", value = FALSE)

)

server <- function(input, output, session) {
  output$res1 <- renderPrint(input$sel1)
  observe({
    req(input$label_text)
    updateSlimSelect(inputId = "sel1", label = input$label_text)
  })
  observe({
    req(input$label_html)
    updateSlimSelect(
      inputId = "sel1",
      label = tags$span(input$label_html, style = "color: red;")
    )
  })

  output$res2 <- renderPrint(input$sel2)
  observe({
    updateSlimSelect(inputId = "sel2", selected = input$selected)
  })

  output$res3 <- renderPrint(input$sel3)
  observe({
    if (identical(input$choices, "lowercase")) {
      updateSlimSelect(inputId = "sel3", choices = tolower(month.name))
    } else {
      updateSlimSelect(inputId = "sel3", choices = toupper(month.name))
    }
  })

  output$res4 <- renderPrint(input$sel4)
  observe({
    if (identical(input$choices_select, "lowercase")) {
      choices <- tolower(month.name)
    } else {
      choices <- toupper(month.name)
    }
    selected <- sample(choices, 1)
    updateSlimSelect(inputId = "sel4", choices = choices, selected = selected)
  })

  output$res5 <- renderPrint(input$sel5)
  observe({
    updateSlimSelect(inputId = "sel5", disable = isTRUE(input$disable))
  })

  observeEvent(input$open, {
    updateSlimSelect(inputId = "sel6", open = input$open)
  }, ignoreInit = TRUE)

}

if (interactive())
  shinyApp(ui, server)
}
\seealso{
\code{\link[=slimSelectInput]{slimSelectInput()}} for creating a widget in the UI.
}
