% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-autonumeric.R
\name{updateCurrencyInput}
\alias{updateCurrencyInput}
\alias{updateFormatNumericInput}
\title{Update a Formatted Numeric Input Widget}
\usage{
updateCurrencyInput(
  session,
  inputId,
  label = NULL,
  value = NULL,
  format = NULL
)

updateFormatNumericInput(
  session,
  inputId,
  label = NULL,
  value = NULL,
  format = NULL
)
}
\arguments{
\item{session}{Standard shiny \code{session}.}

\item{inputId}{The id of the input object.}

\item{label}{The label to set for the input object.}

\item{value}{The value to set for the input object.}

\item{format}{The format to change the input object to.}
}
\description{
Update a Formatted Numeric Input Widget
}
\examples{
if (interactive()) {
  library(shiny)
  library(shinyWidgets)

  ui <- fluidPage(
    tags$h2("Currency Input"),

    currencyInput("id1", "Euro:", value = 1234, format = "euro", width = 200, align = "right"),
    verbatimTextOutput("res1"),
    actionButton("bttn0", "Change Input to Euros"),
    actionButton("bttn1", "Change Input to Dollars"),
    actionButton("bttn2", "Change Input to Yen")
  )

  server <- function(input, output, session) {

    output$res1 <- renderPrint(input$id1)

    observeEvent(input$bttn0, {
      updateCurrencyInput(
        session = session,
        inputId = "id1",
        label = "Euro:",
        format = "euro"
      )
    })
    observeEvent(input$bttn1, {
      updateCurrencyInput(
        session = session,
        inputId = "id1",
        label = "Dollar:",
        format = "dollar"
      )
    })
    observeEvent(input$bttn2, {
      updateCurrencyInput(
        session = session,
        inputId = "id1",
        label = "Yen:",
        format = "Japanese"
      )
    })


  }

  shinyApp(ui, server)
}
}
\seealso{
Other autonumeric: 
\code{\link{autonumericInput}()},
\code{\link{currencyInput}()},
\code{\link{updateAutonumericInput}()}
}
\concept{autonumeric}
