% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup_rpkg.R
\name{setupRPKG}
\alias{setupRPKG}
\alias{viewsBox}
\alias{lfButton}
\title{Setup configuration for shiny page views, likes and followers}
\usage{
setupRPKG(
  viewsID = NULL,
  likesID = NULL,
  followID = NULL,
  session = getDefaultReactiveDomain(),
  icon.follow = shiny::icon("user"),
  icon.unfollow = shiny::icon("user", class = "fa-solid"),
  icon.like = shiny::icon("heart"),
  icon.unlike = shiny::icon("heart", class = "fa-solid"),
  text.follow = "",
  text.unfollow = "",
  text.like = "",
  text.unlike = ""
)

viewsBox(inputId, ...)

lfButton(inputId, width = NULL, suffix = "", ...)
}
\arguments{
\item{viewsID}{Optional. The container ID to display views}

\item{likesID}{Optional. The button ID to display likes}

\item{followID}{Optional. The button ID to display followers}

\item{session}{Optional. Current session to track}

\item{icon.follow}{Optional. shiny::icon() to activate follow}

\item{icon.unfollow}{Optional. shiny::icon() to de-activate follow}

\item{icon.like}{Optional. shiny::icon() to activate likes}

\item{icon.unlike}{Optional. shiny::icon() to de-activate likes}

\item{text.follow}{Optional. text to activate follow}

\item{text.unfollow}{Optional. text to de-activate follow}

\item{text.like}{Optional. text to activate likes}

\item{text.unlike}{Optional. text to de-activate likes}

\item{inputId}{The input slot that will be used to access the value.}

\item{...}{Optional. Named attributes to be applied to the likes or follows button or views box.}

\item{width}{Optional. The width of the button input, e.g. '500px', or '100\%'}

\item{suffix}{suffix to add to likes or followers count}

\item{icon}{Optional. A shiny::icon() to appear on the button.}
}
\description{
To unlock this functionality, you'll need to obtain a FREE API key from https://api.rpkg.net \cr
However, before requesting your API key, it's recommended to do an initial deployment of your app.
This is because the API key generation process requires you to provide the link to your Shiny app.
}
\details{
Utilize the rpkg.net API to store and retrieve page views, likes and followers
}
\examples{
\donttest{
library(shiny)
library(shinyStorePlus)

if (interactive()) {

# replace UI with more elements
ui <- fluidPage(
  initStore("rpkg",rpkg.api.key =
  "c20c5eead7714c119dd3f20bd249a388e72db2aa0f9305d0380b683a37c5296a")
)

# this example is focused on the server
server <- function(input, output, session) {
  setupRPKG(
    session = session,
    viewsID = "viewsshow",
    likesID = "liket",
    followID = "followt",
    icon.follow = shiny::icon("user-plus"),
    icon.unfollow = shiny::icon("user-minus"),
    icon.like = shiny::icon("thumbs-up"),
    icon.unlike = shiny::icon("thumbs-down"),
    text.follow = "Follow us!",
    text.unfollow = "Unfollow us!",
    text.like = "Like us!",
    text.unlike = "Unlike us!"
 )
}


shinyApp(ui = ui, server = server)
}
}

}
