% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7-update-inputs.R
\name{updateF7Checkbox}
\alias{updateF7Checkbox}
\title{Change the value of a checkbox input on the client}
\usage{
updateF7Checkbox(
  inputId,
  label = NULL,
  value = NULL,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{inputId}{The id of the input object.}

\item{label}{The label to set for the input object.}

\item{value}{The value to set for the input object.}

\item{session}{The Shiny session object, usually the default value will suffice.}
}
\description{
Change the value of a checkbox input on the client
}
\examples{
if (interactive()) {
 library(shiny)
 library(shinyMobile)

 ui <- f7Page(
   f7SingleLayout(
    navbar = f7Navbar(title = "updateF7CheckBox"),
    f7Slider(
     inputId = "controller",
     label = "Number of observations",
     max = 10,
     min = 0,
     value = 1,
     step = 1,
     scale = TRUE
    ),
    f7checkBox(
     inputId = "check",
     label = "Checkbox"
    )
   )
 )

 server <- function(input, output, session) {
   observe({
     # TRUE if input$controller is odd, FALSE if even.
     x_even <- input$controller \%\% 2 == 1

     if (x_even) {
      showNotification(
       id = "notif",
       paste("The slider is ", input$controller, "and the checkbox is", input$check),
       duration = NULL,
       type = "warning"
      )
     } else {
      removeNotification("notif")
     }

     updateF7Checkbox("check", value = x_even)
   })
 }

shinyApp(ui, server)
}
}
