% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7-inputs.R
\name{f7Password}
\alias{f7Password}
\title{Create an f7 password input}
\usage{
f7Password(inputId, label, value = "", placeholder = NULL)
}
\arguments{
\item{inputId}{Text input id.}

\item{label}{Text input label.}

\item{value}{Text input value.}

\item{placeholder}{Text input placeholder.}
}
\description{
Create an f7 password input
}
\examples{
if(interactive()){
 library(shiny)
 library(shinyMobile)

 shiny::shinyApp(
   ui = f7Page(
     title = "My app",
     f7SingleLayout(
      navbar = f7Navbar(title = "f7Password"),
      f7Password(
       inputId = "password",
       label = "Password:",
       placeholder = "Your password here"
      ),
      verbatimTextOutput("value")
     )
   ),
   server = function(input, output) {
     output$value <- renderPrint({ input$password })
   }
 )
}
}
