% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/par_table.r
\name{par_table}
\alias{par_table}
\title{Create parameter table}
\usage{
par_table(
  proj,
  models,
  outnm = NULL,
  projloc = ".",
  bsv = FALSE,
  shrink = FALSE,
  backt = FALSE,
  formatting = FALSE,
  ...
)
}
\arguments{
\item{proj}{project object}

\item{models}{character vector with model names to create table for}

\item{outnm}{character with name of the output file (see details)}

\item{projloc}{character with the base location of the shinyMixR project}

\item{bsv}{logical indicating if between subject variability (BSV) should be added to table}

\item{shrink}{logical indicating if shrinkage should be added to table}

\item{backt}{logical indicating if the backtransformed parameters should be returned opposed to the original values}

\item{formatting}{logical indicating if the formatting should be applied to present the table (not implemented for latex output)}

\item{...}{additional arguments passed to \code{\link[R3port]{ltx_plot}} or \code{\link[R3port]{html_plot}}}
}
\value{
in case no outnm is defined a data frame will be returned otherwise
  the results are saved to disk
}
\description{
Creates a table with the final estimates and percentage CV for all parameters in an nlmixr output
file. This can be done for one or multiple models for easy comparison
}
\details{
In case a model is saved, a directory with the name of the model is created within the
  analysis folder of the current project. Then within this folder the file is saved as outnm.
  This method was chosen so the interface can easily index applicable files for a certain model.
  However, this means that output is always saved in this directly regardless of the location of outnm
  In case multiple models are selected the result will be written to the name of the first model in the
  models vector.
}
\examples{

\dontrun{
 par_table(proj,"run1")
}
}
\author{
Richard Hooijmaijers
}
