% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gof_plot.r
\name{gof_plot}
\alias{gof_plot}
\title{Create goodness of fit plots}
\usage{
gof_plot(
  dfrm,
  type = "xpose",
  mdlnm = NULL,
  colby = NULL,
  ptype = "all",
  outnm = NULL,
  projloc = ".",
  title = NULL,
  linscale = FALSE,
  ...
)
}
\arguments{
\item{dfrm}{data frame as created by the nlmixr function}

\item{type}{character defining the type of plot that should be created. currently
"xpose" and "user" are supported for xpose or ggplot style of plots}

\item{mdlnm}{character with name of the model}

\item{colby}{character vector of length one specifying the variable to color on (for now can be only one variable)}

\item{ptype}{The type of plots to create. Currently the following is accepted:
"all", "ipred.dv", "pred.dv", "idv.res", "pred.res"}

\item{outnm}{character with name of the output file (see details)}

\item{projloc}{character with the base location of the shinyMixR project}

\item{title}{character with the title to place above the plot}

\item{linscale}{Logical indicating if the scales should be set to linear for DV, PRED and IPRED plots}

\item{...}{additional arguments passed to \code{\link[R3port]{ltx_plot}} or \code{\link[R3port]{html_plot}}}
}
\value{
in case no outnm is defined a ggplot object will be returned otherwise
  the results are saved to disk
}
\description{
Creates goodness of fit plots either using the xpose.nlmixr package or using a
default ggplot call
}
\details{
In case a model is saved, a directory with the name of the model is created within the
  analysis folder of the current project. Then within this folder the file is saved as outnm.
  This method was chosen so the interface can easily index applicable files for a certain model.
  However, this means that output is always saved in this directly regardless of the location of outnm
}
\examples{

\dontrun{
 gof_plot(res)
}
}
\author{
Richard Hooijmaijers
}
