% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/error_summary.R
\name{error_summary}
\alias{error_summary}
\title{Error Summary Function}
\usage{
error_summary(inputId, error_title, error_list)
}
\arguments{
\item{inputId}{The input slot that will be used to access the value.}

\item{error_title}{The title for the error summary.}

\item{error_list}{A list of text values to be displayed in the error body.}
}
\value{
an error_summary html shiny object
}
\description{
This function loads the error summary component to display error text.
This replicates the gov style error boxes linked below:
https://design-system.service.gov.uk/components/error-summary/
}
\examples{
if (interactive()) {
  ui <- fluidPage(
    shinyjs::useShinyjs(),
    shinyGovstyle::header(
      main_text = "Example",
      secondary_text = "User Examples",
      logo = "shinyGovstyle/images/moj_logo.png"
    ),
    shinyGovstyle::gov_layout(
      size = "two-thirds",
      error_summary(
        inputId = "errorId",
        error_title = "Error title",
        error_list = c("error item1", "error item2")
      )
    ),
    shinyGovstyle::button_Input("btn1", "Change error summary"),
    shinyGovstyle::footer(full = TRUE)
  )

  server <- function(input, output, session) {

    shiny::observeEvent(input$btn1, {
      error_summary_update(
        "errorId",
        c("error item1", "error item2", "error item3")
      )},
      ignoreInit = TRUE
    )
  }
  shinyApp(ui = ui, server = server)
}
}
\keyword{error_summary}
