% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspect_objects.R
\name{inspect_objects}
\alias{inspect_objects}
\title{Copying objects to global environment}
\usage{
inspect_objects(...)
}
\arguments{
\item{...}{Named objects to be copy to the global environment.
If there is only one unnamed object, its name in the global environment
will be the same as the name of the object passed to \code{...}.}
}
\description{
With \code{inspect_objects} you can copy an object to the global environment
for further debugging or developing.
}
\examples{
if (interactive()) {

  set_logging()
  shiny::shinyApp(
    ui = shiny::fluidPage(log_init()),
    server = function(input, output) {
      set_logging_session()
      inspect_objects(mtcars)
      inspect_objects(df1 = head(mtcars), df2 = head(iris))
    }
  )

}
}
