% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modules.R
\name{module_info}
\alias{module_info}
\alias{load_module}
\title{Obtain the module information}
\usage{
module_info(root_path = template_root(), settings_file = "modules.yaml")

load_module(
  root_path = template_root(),
  request = list(QUERY_STRING = "/"),
  env = parent.frame()
)
}
\arguments{
\item{root_path}{the root path of the website project}

\item{settings_file}{the settings file containing the module information}

\item{request}{'HTTP' request string}

\item{env}{environment to load module variables into}
}
\value{
A data frame with the following columns that contain the module
information:
\describe{
\item{\code{id}}{module id, folder name}
\item{\code{order}}{display order in side-bar}
\item{\code{group}}{group menu name if applicable, otherwise \code{NA}}
\item{\code{label}}{the readable label to be displayed on the side-bar}
\item{\code{icon}}{icon that will be displayed ahead of label, will be
passed to \code{\link{as_icon}}}
\item{\code{badge}}{badge text that will be displayed
following the module label, will be passed to \code{\link{as_badge}}}
\item{\code{url}}{the relative 'URL' address of the module.}
}
}
\description{
Obtain the module information
}
\details{
The module files are stored in \code{modules/} folder in your
project. The folder names are the module id. Within each folder,
there should be one \code{"server.R"}, \code{R/}, and a
\code{"module-ui.html"}.

The \code{R/} folder stores R code files that generate variables,
which will be available to the other two files. These variables, along
with some built-ins, will be used to render \code{"module-ui.html"}.
The built-in functions are
\describe{
\item{ns}{shiny name-space function; should be used to generate the id for
inputs and outputs. This strategy avoids conflict id effectively.}
\item{.module_id}{a variable of the module id}
\item{module_title}{a function that returns the module label}
}

The \code{"server.R"} has access to all the code in \code{R/} as well.
Therefore it is highly recommended that you write each 'UI' component
side-by-side with their corresponding server functions and call
these server functions in \code{"server.R"}.
}
\examples{

library(shiny)
module_info()

# load master module
load_module()

# load specific module
module_data <- load_module(
  request = list(QUERY_STRING = "/?module=module_id"))
env <- module_data$environment

if(interactive()){

# get module title
env$module_title()

# generate module-specific shiny id
env$ns("input1")

# generate part of the UI
env$ui()

}

}
