% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TargetingModels.R
\name{createTargetingMatrix}
\alias{createTargetingMatrix}
\title{Calculates a targeting rate matrix}
\usage{
createTargetingMatrix(substitutionModel, mutabilityModel)
}
\arguments{
\item{substitutionModel}{matrix of 5-mers substitution rates built by 
\code{\link{createSubstitutionMatrix}} or 
\code{\link{extendSubstitutionMatrix}}.}

\item{mutabilityModel}{vector of 5-mers mutability rates built by 
\code{\link{createMutabilityMatrix}} or 
\code{\link{extendMutabilityMatrix}}.}
}
\value{
A matrix with the same dimensions as the input \code{substitutionModel} 
          containing normalized targeting probabilities for each 5-mer motif with 
          row names defining the center nucleotide and column names defining the 
          5-mer nucleotide sequence.
}
\description{
\code{createTargetingMatrix} calculates the targeting model matrix as the
combined probability of mutability and substitution.
}
\details{
Targeting rates are calculated by multiplying the normalized mutability rate by the 
normalized substitution rates for each individual 5-mer.
}
\examples{
# Subset example data to one isotype and sample as a demo
db <- subset(InfluenzaDb, CPRIMER == "IGHA" & BARCODE == "RL014")

# Create 4x1024 model using only silent mutations and ignore multiple mutations
sub_model <- createSubstitutionMatrix(db, model="S", multipleMutation="ignore")
mut_model <- createMutabilityMatrix(db, sub_model, model="S", multipleMutation="ignore",
                                    minNumSeqMutations=10)
tar_model <- createTargetingMatrix(sub_model, mut_model)

# Create 5x3125 model including Ns
sub_model <- extendSubstitutionMatrix(sub_model)
mut_model <- extendMutabilityMatrix(mut_model)
tar_model <- createTargetingMatrix(sub_model, mut_model)

}
\references{
\enumerate{
  \item  Yaari G, et al. Models of somatic hypermutation targeting and substitution based
           on synonymous mutations from high-throughput immunoglobulin sequencing data.
           Front Immunol. 2013 4(November):358.
 }
}
\seealso{
Other targeting model functions: \code{\link{calcTargetingDistance}},
  \code{\link{createMutabilityMatrix}},
  \code{\link{createSubstitutionMatrix}},
  \code{\link{createTargetingModel}},
  \code{\link{extendMutabilityMatrix}},
  \code{\link{extendSubstitutionMatrix}},
  \code{\link{plotMutability}},
  \code{\link{writeTargetingDistance}}
}

