% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TargetingModels.R
\name{calcTargetingDistance}
\alias{calcTargetingDistance}
\title{Calculates a 5-mer distance matrix from a TargetingModel object}
\usage{
calcTargetingDistance(model)
}
\arguments{
\item{model}{\link{TargetingModel} object with mutation likelihood information.}
}
\value{
A matrix of distances for each 5-mer motif with rows names defining 
          the center nucleotide and column names defining the 5-mer nucleotide 
          sequence.
}
\description{
\code{calcTargetingDistance} converts the targeting rates in a TargetingModel model 
to a matrix of 5-mer to single-nucleotide mutation distances.
}
\details{
The targeting model is transformed into a distance matrix by:
\enumerate{
  \item  Converting the likelihood of being mutated \eqn{p=mutability*substitution} to 
         distance \eqn{d=-log10(p)}.
  \item  Dividing this distance by the mean of the distances
  \item  Converting all infinite, no change (e.g., A->A), and NA distances to 
         zero.
}
}
\examples{
# Calculate targeting distance of HS5FModel
dist <- calcTargetingDistance(HS5FModel)

}
\seealso{
Takes as input a \link{TargetingModel} object.

Other targeting model functions: \code{\link{createMutabilityMatrix}},
  \code{\link{createSubstitutionMatrix}},
  \code{\link{createTargetingMatrix}},
  \code{\link{createTargetingModel}},
  \code{\link{extendMutabilityMatrix}},
  \code{\link{extendSubstitutionMatrix}},
  \code{\link{plotMutability}},
  \code{\link{writeTargetingDistance}}
}

