% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_SSURGO_hydro_data.R
\name{prepare_SSURGO_hydro_data}
\alias{prepare_SSURGO_hydro_data}
\title{Get and prepare basic soil hydraulic parameters from SSURGO via SDA}
\usage{
prepare_SSURGO_hydro_data(cokeys, max.depth)
}
\arguments{
\item{cokeys}{vector of component keys (cokey) in current SSURGO snapshot}

\item{max.depth}{target depth of aggregation (cm), corrected later by real soil depth as reported by \code{slab()}}
}
\value{
a \code{list} containing:
\itemize{
\item \code{SPC}: \code{SoilProfileCollection}
\item \code{agg}: aggregate representation of hydraulic parameters, by cokey
}
}
\description{
Get and prepare basic soil hydraulic parameters from SSURGO via SDA
}
\details{
Weighted mean soil hydraulic parameters are returned over the interval of \code{0-max.depth}, calculated by \code{aqp::slab()}.
}
\author{
D.E. Beaudette
}
