% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimensionality_reduction.R
\name{GroupPLS}
\alias{GroupPLS}
\title{Group Partial Least Squares}
\usage{
GroupPLS(
  xdata,
  ydata,
  family = "gaussian",
  group_x,
  group_y = NULL,
  Lambda,
  keepX_previous = NULL,
  keepY = NULL,
  ncomp = 1,
  scale = TRUE,
  ...
)
}
\arguments{
\item{xdata}{matrix of predictors with observations as rows and variables as
columns.}

\item{ydata}{optional vector or matrix of outcome(s). If \code{family} is set
to \code{"binomial"} or \code{"multinomial"}, \code{ydata} can be a vector
with character/numeric values or a factor.}

\item{family}{type of PLS model. If \code{family="gaussian"}, a group PLS
model as defined in \code{\link[sgPLS]{gPLS}} is run (for continuous
outcomes). If \code{family="binomial"}, a PLS-DA model as defined in
\code{\link[sgPLS]{gPLSda}} is run (for categorical outcomes).}

\item{group_x}{vector encoding the grouping structure among predictors. This
argument indicates the number of variables in each group.}

\item{group_y}{optional vector encoding the grouping structure among
outcomes. This argument indicates the number of variables in each group.}

\item{Lambda}{matrix of parameters controlling the number of selected groups
at current component, as defined by \code{ncomp}.}

\item{keepX_previous}{number of selected groups in previous components. Only
used if \code{ncomp > 1}. The argument \code{keepX} in
\code{\link[sgPLS]{sgPLS}} is obtained by concatenating
\code{keepX_previous} and \code{Lambda}.}

\item{keepY}{number of selected groups of outcome variables. This argument is
defined as in \code{\link[sgPLS]{sgPLS}}. Only used if
\code{family="gaussian"}.}

\item{ncomp}{number of components.}

\item{scale}{logical indicating if the data should be scaled (i.e.
transformed so that all variables have a standard deviation of one). Only
used if \code{family="gaussian"}.}

\item{...}{additional arguments to be passed to \code{\link[sgPLS]{gPLS}} or
\code{\link[sgPLS]{gPLSda}}.}
}
\value{
A list with: \item{selected}{matrix of binary selection status. Rows
  correspond to different model parameters. Columns correspond to
  predictors.} \item{beta_full}{array of model coefficients. Rows correspond
  to different model parameters. Columns correspond to predictors (starting
  with "X") or outcomes (starting with "Y") variables for different
  components (denoted by "PC").}
}
\description{
Runs a group Partial Least Squares model using implementation from
\code{\link[sgPLS]{sgPLS-package}}. This function is not using stability.
}
\examples{
## Group PLS
# Data simulation
set.seed(1)
simul <- SimulateRegression(n = 100, pk = 50, q = 3, family = "gaussian")
x <- simul$xdata
y <- simul$ydata

# Running gPLS with 1 group and sparsity of 0.5
mypls <- GroupPLS(
  xdata = x, ydata = y, Lambda = 1, family = "gaussian",
  group_x = c(10, 15, 25),
)

# Running gPLS with groups on outcomes
mypls <- GroupPLS(
  xdata = x, ydata = y, Lambda = 1, family = "gaussian",
  group_x = c(10, 15, 25),
  group_y = c(2, 1), keepY = 1
)

## Group PLS-DA
# Data simulation
set.seed(1)
simul <- SimulateRegression(n = 100, pk = 50, family = "binomial")

# Running sgPLS-DA with 1 group and sparsity of 0.9
mypls <- GroupPLS(
  xdata = simul$xdata, ydata = simul$ydata, Lambda = 1, family = "binomial",
  group_x = c(10, 15, 25), test = 0
)
}
\references{
\insertRef{sparsegroupPLS}{sharp}
}
\seealso{
\code{\link{VariableSelection}}, \code{\link{BiSelection}}

Other penalised dimensionality reduction functions: 
\code{\link{SparseGroupPLS}()},
\code{\link{SparsePCA}()},
\code{\link{SparsePLS}()}
}
\concept{penalised dimensionality reduction functions}
