\name{cortical}
\alias{cortical}
\title{Cortical surface data}
\description{Cortical surface data, from MR scans. Axial slice outlines with 
500 points on each outline. 68 individuals. 
}
\usage{data(cortical)}
\format{
cortical$age   ( age)
cortical$group ( Control, Schizophrenia)
cortical$sex   ( 1 = male, 2 = female)
cortical$symm  ( a symmetry measure 
                 from the original 3D cortical surface )

cortical$x     (500 x , y  coordinates of an axial slice through the
                cortical surface intersecting the anterior and posterior 
                commissures)

cortical$r     (500 radii from equal angular polar coordinates )
}
\source{
Brignell, C.J., Dryden, I.L., Gattone, S.A., Park, B., Leask, S., Browne, W.J. and Flynn, S. (2010).
Surface shape analysis, with an application to brain surface asymmetry in schizophrenia. Biostatistics,
11, 609-630.

Dryden, I.L. (2005). Statistical analysis on high-dimensional spheres and shape spaces. Annals of Statistics,
33, 1643-1665
}
\references{
Original MR data from Sean Flynn (UBC) in collaboration with Bert Park (Nottingham). 
}
\examples{
data(cortical)
plotshapes(cortical$x)
}
\keyword{datasets}

