% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiftAz.R
\name{shiftAz}
\alias{shiftAz}
\title{Shift features by azimuth and distance}
\usage{
shiftAz(object, az, dist)
}
\arguments{
\item{object}{The object to be shifted.}

\item{az}{Shift azimuth, in decimal degrees.}

\item{dist}{Shift distance, in \code{object} projection units.}
}
\value{
The shifted \code{object}.
}
\description{
Shift features by azimuth and distance
}
\examples{
s = c(270, 90, 180, 0)
build_shifted = shiftAz(build, az = s, dist = 2.5)
plot(build)
plot(build_shifted, add = TRUE, border = "red")
raster::text(rgeos::gCentroid(build, byid = TRUE), s)

}
