% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spacetime-cube-complete.R
\name{complete_spacetime_cube}
\alias{complete_spacetime_cube}
\title{Convert spacetime object to spacetime cube}
\usage{
complete_spacetime_cube(x, ...)
}
\arguments{
\item{x}{a spacetime object.}

\item{...}{unused}
}
\value{
A spacetime object that meets the criteria of spacetime cube.
}
\description{
Given a spacetime object, convert it to a spacetime cube. A spacetime cube
ensures that there is a regular time-series for each geometry present.
}
\details{
If observations are missing for a time period and location combination,
columns will be populated with NAs.

See \code{\link[=is_spacetime_cube]{is_spacetime_cube()}} for more details on spacetime cubes.
}
\examples{

df_fp <- system.file("extdata", "bos-ecometric.csv", package = "sfdep")
geo_fp <- system.file("extdata", "bos-ecometric.geojson", package = "sfdep")

# read in data
df <- read.csv(df_fp, colClasses = c("character", "character", "integer", "double", "Date"))
geo <- sf::st_read(geo_fp)

# Create spacetime object called `bos`
bos <- spacetime(df, geo,
                 .loc_col = ".region_id",
                 .time_col = "time_period")

# create a sample of data
set.seed(0)
sample_index <- sample(1:nrow(bos), nrow(bos) * 0.95)
incomplete_spt <- bos[sample_index,]

# check to see if is spacetime cube
is_spacetime_cube(incomplete_spt)

# complete it again
complete_spacetime_cube(incomplete_spt)
}
