% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/global-measures.R
\name{global_moran}
\alias{global_moran}
\title{Calculate Global Moran's I}
\usage{
global_moran(x, nb, wt, na_ok = FALSE, ...)
}
\arguments{
\item{x}{A numeric vector.}

\item{nb}{a neighbor list object for example as created by \code{st_contiguity()}.}

\item{wt}{a weights list as created by \code{st_weights()}.}

\item{na_ok}{default \code{FALSE}. If \code{FALSE} presence or \code{NA} or \code{Inf} results in an error.}

\item{...}{additional arguments passed to \code{\link[spdep:moran]{spdep::moran()}}.}
}
\value{
an \code{htest} object
}
\description{
Calculate Global Moran's I
}
\examples{
nb <- guerry_nb$nb
wt <- guerry_nb$wt
x <- guerry_nb$crime_pers
moran <- global_moran(x, nb, wt)
}
\seealso{
Other global_moran: 
\code{\link{global_moran_bv}()},
\code{\link{global_moran_perm}()},
\code{\link{global_moran_test}()},
\code{\link{local_moran_bv}()}
}
\concept{global_moran}
