% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcov.R
\name{vcov}
\alias{vcov}
\alias{vcov.sfacross}
\alias{vcov.sfalcmcross}
\alias{vcov.sfaselectioncross}
\title{Compute variance-covariance matrix of stochastic frontier models}
\usage{
\method{vcov}{sfacross}(object, extraPar = FALSE, ...)

\method{vcov}{sfalcmcross}(object, ...)

\method{vcov}{sfaselectioncross}(object, extraPar = FALSE, ...)
}
\arguments{
\item{object}{A stochastic frontier model returned
by \code{\link{sfacross}}, \code{\link{sfalcmcross}}, or
\code{\link{sfaselectioncross}}.}

\item{extraPar}{Logical. Only available for non heteroscedastic models
returned by \code{\link{sfacross}} and \code{\link{sfaselectioncross}}.
Default = \code{FALSE}. If \code{TRUE}, variances and covariances of
additional parameters are returned:

\code{sigmaSq} = \code{sigmauSq} + \code{sigmavSq}

\code{lambdaSq} = \code{sigmauSq}/\code{sigmavSq}

\code{sigmauSq} = \eqn{\exp{(Wu)}} = \eqn{\exp{(\bm{\delta} \mathbf{Z}_u)}}

\code{sigmavSq} = \eqn{\exp{(Wv)}} = \eqn{\exp{(\bm{\phi} \mathbf{Z}_v)}}

\code{sigma} = \code{sigmaSq}^0.5

\code{lambda} = \code{lambdaSq}^0.5

\code{sigmau} = \code{sigmauSq}^0.5

\code{sigmav} = \code{sigmavSq}^0.5

\code{gamma} = \code{sigmauSq}/(\code{sigmauSq} + \code{sigmavSq})}

\item{...}{Currently ignored}
}
\value{
The variance-covariance matrix of the maximum likelihood
coefficients is returned.
}
\description{
\code{\link{vcov}} computes the variance-covariance matrix of the maximum
likelihood (ML) coefficients from stochastic frontier models estimated with
\code{\link{sfacross}}, \code{\link{sfalcmcross}},
or \code{\link{sfaselectioncross}}.
}
\details{
The variance-covariance matrix is obtained by the inversion of the
negative Hessian matrix. Depending on the distribution and the
\code{'hessianType'} option, the analytical/numeric Hessian or the bhhh
Hessian is evaluated.

The argument \code{extraPar}, is currently available only for objects of class
\code{'sfacross'} and \code{'sfaselectioncross'}. When
\code{'extraPar = TRUE'}, the variance-covariance of the additional
parameters is obtained using the delta method.
}
\examples{

## Using data on Spanish dairy farms
# Cobb Douglas (production function) half normal distribution
cb_s_h <- sfacross(formula = YIT ~ X1 + X2 + X3 + X4, udist = 'hnormal',
data = dairyspain, S = 1, method = 'bfgs')
vcov(cb_s_h)
vcov(cb_s_h, extraPar = TRUE)
 
# Other variance-covariance matrices can be obtained using the sandwich package
 
# Robust variance-covariance matrix
 
requireNamespace('sandwich', quietly = TRUE)
 
sandwich::vcovCL(cb_s_h)
 
# Coefficients and standard errors can be obtained using lmtest package
 
requireNamespace('lmtest', quietly = TRUE)
 
lmtest::coeftest(cb_s_h, vcov. = sandwich::vcovCL)
 
# Clustered standard errors
 
lmtest::coeftest(cb_s_h, vcov. = sandwich::vcovCL, cluster = ~ FARM)
 
# Doubly clustered standard errors
 
lmtest::coeftest(cb_s_h, vcov. = sandwich::vcovCL, cluster = ~ FARM + YEAR)
 
# BHHH standard errors
 
lmtest::coeftest(cb_s_h, vcov. = sandwich::vcovOPG)
 
# Adjusted BHHH standard errors
 
lmtest::coeftest(cb_s_h, vcov. = sandwich::vcovOPG, adjust = TRUE)

## Using data on eighty-two countries production (GDP)
# LCM Cobb Douglas (production function) half normal distribution
cb_2c_h <- sfalcmcross(formula = ly ~ lk + ll + yr, udist = 'hnormal',
data = worldprod, uhet = ~ initStat, S = 1)
vcov(cb_2c_h)

}
\seealso{
\code{\link{sfacross}}, for the stochastic frontier analysis model
fitting function using cross-sectional or pooled data.

\code{\link{sfalcmcross}}, for the latent class stochastic frontier analysis
model fitting function using cross-sectional or pooled data.

\code{\link{sfaselectioncross}} for sample selection in stochastic frontier
model fitting function using cross-sectional data.
}
\keyword{methods}
\keyword{vcov}
