% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sf.R
\name{transform.sf}
\alias{transform.sf}
\title{transform method for sf objects}
\usage{
\method{transform}{sf}(`_data`, ...)
}
\arguments{
\item{_data}{object of class \code{sf}}

\item{...}{Further arguments of the form new_variable=expression}
}
\description{
Can be used to create or modify attribute variables; for transforming geometries see 
\link{st_transform}, and all other functions starting with \code{st_}.
}
\examples{
a = data.frame(x1 = 1:3, x2 = 5:7)
st_geometry(a) = st_sfc(st_point(c(0,0)), st_point(c(1,1)), st_point(c(2,2)))
transform(a, x1_sq = x1^2)
transform(a, x1_x2 = x1*x2)
}
