% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{st_drivers}
\alias{st_drivers}
\title{Get GDAL drivers}
\usage{
st_drivers(what = "vector", regex)
}
\arguments{
\item{what}{character: \code{"vector"} or \code{"raster"}, anything else will return all
drivers.}

\item{regex}{character; regular expression to filter the \code{name} and \code{long_name}
fields on}
}
\value{
A \code{data.frame} with driver metadata.
}
\description{
Get a list of the available GDAL drivers
}
\details{
The drivers available will depend on the installation of GDAL/OGR,
and can vary; the \code{st_drivers()} function shows all the drivers that are
readable, and which may be written. The field \code{vsi} refers to the driver's
capability to read/create datasets through the VSI*L API. \href{https://gdal.org/drivers/vector/index.html}{See GDAL website for additional details on driver support}.
}
\examples{
# The following driver lists depend on the GDAL setup and platform used:
st_drivers()
st_drivers("raster", "GeoT")
}
