% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{st_read}
\alias{st_read}
\alias{st_read_db}
\title{read simple features from file or database}
\usage{
st_read(dsn, layer = default_layer(dsn), ..., options = NULL,
  quiet = FALSE, iGeomField = 1L, type = 0, promote_to_multi = TRUE)

st_read_db(conn = NULL, table, query = paste("select * from ", table, ";"),
  geom_column = NULL, EWKB, ...)
}
\arguments{
\item{dsn}{data source name (interpretation varies by driver - for some drivers, dsn is a file name, but may also be a folder)}

\item{layer}{layer name (varies by driver, may be a file name without extension); see details}

\item{...}{parameter(s) passed on to \link{st_as_sf}}

\item{options}{character; driver dependent dataset open options; multiple options supported.}

\item{quiet}{logical; suppress info on name, driver, size and spatial reference}

\item{iGeomField}{integer; in case of multiple geometry fields, which one to take?}

\item{type}{integer; ISO number of desired simple feature type; see details. If left zero, in case of mixed feature geometry types, conversion to the highest numeric type value found will be attempted.}

\item{promote_to_multi}{logical; in case of a mix of LineString and MultiLineString, or of Polygon and MultiPolygon, convert all to the Multi variety; defaults to \code{TRUE}}

\item{conn}{open database connection}

\item{table}{table name}

\item{query}{SQL query to select records}

\item{geom_column}{character or integer: indicator of name or position of the geometry column; if not provided, the last column of type character is chosen}

\item{EWKB}{logical; is the WKB is of type EWKB? defaults to TRUE if \code{conn} is of class code{PostgreSQLConnection} or \code{PqConnection}}
}
\value{
object of class \link{sf}
}
\description{
read simple features from file or database

read PostGIS table directly through DBI and RPostgreSQL interface, converting binary
}
\details{
for iGeomField, see also \url{https://trac.osgeo.org/gdal/wiki/rfc41_multiple_geometry_fields}; for \code{type} values see \url{https://en.wikipedia.org/wiki/Well-known_text#Well-known_binary}, but note that not every target value may lead to succesful conversion. The typical conversion from POLYGON (3) to MULTIPOLYGON (6) should work; the other way around (type=3), secondary rings from MULTIPOLYGONS may be dropped without warnings.

layer name may be guessed in some cases e.g. when \code{dsn} contains the full path of a geopackage or a shapefile (with extension .shp), and it will try to do so; this may fail in other cases, though; it is often a good idea to specify both basename and layer name.

in case geom_column is missing: if table is missing, this function will try to read the name of the geometry column from table \code{geometry_columns}, in other cases, or when this fails, the geom_column is assumed to be the last column of mode character.
}
\examples{
if (Sys.getenv("USER") \%in\% c("edzer", "travis")) { # load meuse to postgis
 library(sp)
 example(meuse, ask = FALSE, echo = FALSE)
 st_write(st_as_sf(meuse), "PG:dbname=postgis", "meuse", driver = "PostgreSQL", 
   options = "OVERWRITE=true")
 (s = st_read("PG:dbname=postgis", "meuse"))
 summary(s)
}
# nc = st_read(system.file("gpkg/nc.gpkg", package="sf"), "nc.gpkg", crs = 4267)
nc = st_read(system.file("shape/nc.shp", package="sf"), "nc", crs = 4267)
summary(nc)
if (Sys.getenv("USER") \%in\% c("travis", "edzer")) {
  library(RPostgreSQL)
  conn = dbConnect(PostgreSQL(), dbname = "postgis")
  st_read_db(conn, query = "select * from meuse limit 3;")
  dbDisconnect(conn)
}
}

