% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{residualResampling}
\alias{residualResampling}
\title{Compute an ancestry vector for residual resampling of the SMC particles.}
\usage{
residualResampling(log_wt)
}
\arguments{
\item{log_wt}{logarithms of the importance weights of each particle.}
}
\value{
Vector of indices to the particles that will be propagated forward to the next generation (i.e. the parents)
}
\description{
Compute an ancestry vector for residual resampling of the SMC particles.
}
\references{
Liu & Chen (1998) "Sequential Monte Carlo methods for dynamic systems," JASA 93(443): 1032-1044,
DOI: \href{http://dx.doi.org/10.1080/01621459.1998.10473765}{10.1080/01621459.1998.10473765}

Douc, Cappe & Moulines (2005) "Comparison of resampling schemes for particle filtering"
In Proc. 4th IEEE Int. Symp. ISPA, pp. 64-69,
DOI: \href{http://dx.doi.org/10.1109/ISPA.2005.195385}{10.1109/ISPA.2005.195385}
}
