% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_pop_data.R
\name{as_pop_data}
\alias{as_pop_data}
\title{Load a cross-sectional antibody survey data set}
\usage{
as_pop_data(
  data,
  antigen_isos = NULL,
  age = "Age",
  value = "result",
  id = "index_id",
  standardize = TRUE
)
}
\arguments{
\item{data}{a \code{\link[=data.frame]{data.frame()}} or \link[tibble:tbl_df-class]{tibble::tbl_df}}

\item{antigen_isos}{\code{\link[=character]{character()}}
vector of antigen isotypes to be used in analyses}

\item{age}{a \code{\link[=character]{character()}} identifying the age column}

\item{value}{a \code{\link[=character]{character()}} identifying the value column}

\item{id}{a \code{\link[=character]{character()}} identifying the id column}

\item{standardize}{a \code{\link[=logical]{logical()}} to determine standardization of columns}
}
\value{
a \code{pop_data} object (a \link[tibble:tbl_df-class]{tibble::tbl_df}
with extra attribute \code{antigen_isos})
}
\description{
Load a cross-sectional antibody survey data set
}
\examples{
library(magrittr)
xs_data <-
  serocalculator_example("example_pop_data.csv") \%>\%
  read.csv() \%>\%
  as_pop_data()

print(xs_data)
}
