% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Simulate.R
\name{SimGeno}
\alias{SimGeno}
\title{Simulated genotypes}
\usage{
SimGeno(Ped = NULL, nSnp = 400, ParMis = 0.4, MAF = NULL,
  OutFile = NA, nGen = 20, PropLQ = 0, MisHQ = 0.005,
  MisLQ = 0.3, ErHQ = 5e-04, ErLQ = 0.005, quiet = FALSE)
}
\arguments{
\item{Ped}{Dataframe, pedigree with columns ID - dam - sire; additional
columns are ignored.}

\item{nSnp}{number of SNPs to simulate.}

\item{ParMis}{proportion of parents with fully missing genotype.}

\item{MAF}{(optional) vector with minor allele frequency at each locus.
If none specified, allele frequencies will be sampled from a uniform
distribution between 0.3 and 0.5.}

\item{OutFile}{filename for simulated genotypes. If NA (default), return
matrix with genotypes within R.}

\item{nGen}{maximum number of generations to consider (pedigree depth).}

\item{PropLQ}{proportion of low-quality samples.}

\item{MisHQ}{average missingness for high-quality samples, assuming a
beta-disstribution with alpha = 1.}

\item{MisLQ}{average missingness in low-quality samples.}

\item{ErHQ}{error rate in high quality samples (defaults to 0.005).}

\item{ErLQ}{error rate in low quality samples.}

\item{quiet}{suppress messages.}
}
\value{
A matrix with genotype data in sequoia's input format, encoded as
 0/1/2/-9.
}
\description{
Simulate SNP genotype data from a pedigree, with optional
 missingess and errors.
}
\details{
Provide either a pedigree dataframe, or the name of a text file
containing
  the pedigree. Please ensure the pedigree is a valid pedigree, for example
  by first running fixPedigree() from library Pedantics.

Errors are generated by replacing randomly chosen genotypes with random
 genotypes, with equal probabilities. As this will not result in a change in
 genotype in around 1/3rd of cases, the number of replaced genotypes is nSnp
 X n individuals X error rate X 3/2
}
\section{Disclaimer}{

This simulation is highly simplistic and assumes that all SNPs segregate
completely independently, and that the SNPs are in Hardy-Weinberg
equilibrium in the pedigree founders. Results based on this simulated data
 will provide an minimum estimate of the number of SNPs required, and an
 optimistic estimate of pedigree reconstruction performance.
}

\examples{
data(Ped_HSg5)
GenoM <- SimGeno(Ped = Ped_HSg5, nSnp = 100, ParMis = 0.2)

}
\seealso{
\code{\link{EstConf}}
}
\author{
Jisca Huisman, \email{jisca.huisman@gmail.com}
}
