% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geograbber_process.R
\name{geograbber_process}
\alias{geograbber_process}
\title{Preprocess (clip, reproject, reshape, mask) SAFE products}
\usage{
geograbber_process(path_safe, path_out, bbox = NA,
  list_prods = c("BOA"), res = NA, ...)
}
\arguments{
\item{path_safe}{Path of the directory in which SAFE
products are searched.}

\item{path_out}{Path of the directory in which Sentinel-2
output products are generated.}

\item{bbox}{(optional) Four-length numeric vector with the bounding box
of the output products (xmin, ymin, xmax, ymax), in geographic coordinates.}

\item{list_prods}{(optional) Character vector with the values of the
products to be processed (accepted values: "TOA", "BOA", "SCL",
"TCI"). Default is "BOA".}

\item{res}{(optional) Numeric vector of length 2 with the x-y resolution
for output products. NA (default) means that the resolution
is kept as native.}

\item{...}{Other additional \link{sen2r} arguments:
\code{extent_name}, \code{list_indices}, \code{index_source}, \code{mask_type}, \code{max_mask},
\code{mask_smooth}, \code{mask_buffer}, \code{clip_on_extent}, \code{extent_as_mask},
\code{reference_path}, \code{res_s2}, \code{unit}, \code{proj}, \code{resampling}, \code{resampling_scl},
\code{outformat}, \code{index_datatype}, \code{compression}, \code{overwrite}, \code{path_tiles},
\code{path_merged}, \code{path_indices}, \code{path_subdirs}, \code{thumbnails},
\code{parallel}, \code{tmpdir}, \code{rmtmp}.
See \link{sen2r} documentation for details.}
}
\description{
The function is a simplified wrapper of \code{\link[=sen2r]{sen2r()}}
to preprocess existing SAFE products. No online research is performed,
neither sen2cor is applied to existing L1C products.
Output products are GeoTIFF files clipped to a desired
}
